/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore.loader;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.apache.logging.log4j.util.Supplier;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.pureore.loader.IPureOreLoader;
import sirttas.elementalcraft.pureore.loader.LoadedPureOre;

public abstract class AbstractPureOreLoader
implements IPureOreLoader {
    final HolderSet<Item> source;
    final int elementConsumption;
    final int inputSize;
    final int outputSize;
    final double luckRatio;
    private final int order;

    protected AbstractPureOreLoader(HolderSet<Item> source, int elementConsumption, int inputSize, int outputSize, double luckRatio, int order) {
        this.source = source;
        this.elementConsumption = elementConsumption;
        this.inputSize = inputSize;
        this.outputSize = outputSize;
        this.luckRatio = luckRatio;
        this.order = order;
    }

    protected static <U extends AbstractPureOreLoader> Products.P6<RecordCodecBuilder.Mu<U>, HolderSet<Item>, Integer, Integer, Integer, Double, Integer> codec(RecordCodecBuilder.Instance<U> builder) {
        return builder.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM).fieldOf("source").forGetter(l -> l.source), (App)Codec.INT.optionalFieldOf("element_consumption", (Object)2500).forGetter(l -> l.elementConsumption), (App)Codec.INT.optionalFieldOf("input_size", (Object)1).forGetter(l -> l.inputSize), (App)Codec.INT.optionalFieldOf("output_size", (Object)2).forGetter(l -> l.outputSize), (App)Codec.DOUBLE.optionalFieldOf("luck_ratio", (Object)0.0).forGetter(l -> l.luckRatio), (App)Codec.INT.optionalFieldOf("order", (Object)Integer.MAX_VALUE).forGetter(AbstractPureOreLoader::getOrder));
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public List<LoadedPureOre> generate(RegistryAccess registry) {
        return List.copyOf(this.generatePureOres().values());
    }

    private Map<ResourceLocation, LoadedPureOre> generatePureOres() {
        List<Holder<Item>> list = this.streamSource().toList();
        ResourceLocation id = this.getId();
        if (list.isEmpty()) {
            ElementalCraftApi.LOGGER.debug("No source stacks found for {}", (Object)id);
            return Collections.emptyMap();
        }
        HashMap<ResourceLocation, LoadedPureOre> pureOres = new HashMap<ResourceLocation, LoadedPureOre>();
        ElementalCraftApi.LOGGER.info("Loading pure ores: {}.\r\n\tSource ores: {}", new Supplier[]{() -> id, () -> list.stream().mapMulti(ElementalCraftUtils.cast(Holder.Reference.class)).map(r -> r.key().location().toString()).collect(Collectors.joining(", "))});
        list.forEach(holder -> this.register(pureOres, (Holder<Item>)holder));
        return pureOres;
    }

    @Nonnull
    public ResourceLocation getId() {
        return ElementalCraft.PURE_ORE_LOADERS_MANAGER.getId((Object)this);
    }

    @Nonnull
    public Stream<Holder<Item>> streamSource() {
        return this.source.stream();
    }

    private LoadedPureOre register(Map<ResourceLocation, LoadedPureOre> pureOres, Holder<Item> ore) {
        for (LoadedPureOre generatedPureOre : pureOres.values()) {
            if (!generatedPureOre.contains(ore)) continue;
            return generatedPureOre;
        }
        PureOreTagGroup generated = this.load(pureOres, ore);
        LoadedPureOre entry = pureOres.computeIfAbsent(generated.id(), i -> new LoadedPureOre((ResourceLocation)i, this.elementConsumption, this.inputSize, this.outputSize, this.luckRatio));
        entry.getOres().add(ore);
        generated.tags().forEach(entry::addTag);
        return entry;
    }

    protected abstract PureOreTagGroup load(Map<ResourceLocation, LoadedPureOre> var1, Holder<Item> var2);

    public record PureOreTagGroup(ResourceLocation id, List<TagKey<Item>> tags) {
    }
}

