/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore.factory;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.commons.lang3.function.Consumers;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.pureore.PureOreException;
import sirttas.elementalcraft.api.pureore.factory.IPureOreRecipeFactoryType;
import sirttas.elementalcraft.interaction.ECInteractions;
import sirttas.elementalcraft.interaction.ie.IEInteraction;
import sirttas.elementalcraft.interaction.mekanism.MekanismInteraction;
import sirttas.elementalcraft.pureore.factory.PureOreCookingRecipeFactory;
import sirttas.elementalcraft.pureore.factory.PureOreGrindingRecipeFactory;
import sirttas.elementalcraft.registry.RegistryHelper;

@EventBusSubscriber(modid="elementalcraft", bus=EventBusSubscriber.Bus.MOD)
public class PureOreRecipeFactoryTypes {
    public static final ResourceKey<Registry<IPureOreRecipeFactoryType<?, ?>>> REGISTRY_KEY = ElementalCraft.createRegistryKey("pure_ore_recipe_factory_type");
    private static final DeferredRegister<IPureOreRecipeFactoryType<?, ?>> DEFERRED_REGISTER = DeferredRegister.create(REGISTRY_KEY, (String)"elementalcraft");
    public static final Registry<IPureOreRecipeFactoryType<?, ?>> REGISTRY = DEFERRED_REGISTER.makeRegistry(Consumers.nop());

    private PureOreRecipeFactoryTypes() {
    }

    @SubscribeEvent
    public static void registerPureOreRecipeInjectors(RegisterEvent event) {
        event.register(REGISTRY_KEY, helper -> {
            PureOreRecipeFactoryTypes.registerCooking(helper, RecipeType.SMELTING, SmeltingRecipe::new);
            PureOreRecipeFactoryTypes.registerCooking(helper, RecipeType.BLASTING, BlastingRecipe::new);
            PureOreRecipeFactoryTypes.registerCooking(helper, RecipeType.SMOKING, SmokingRecipe::new);
            PureOreRecipeFactoryTypes.registerCooking(helper, RecipeType.CAMPFIRE_COOKING, CampfireCookingRecipe::new);
            PureOreRecipeFactoryTypes.register(helper, "grinding", PureOreGrindingRecipeFactory::new);
            if (ECInteractions.isMekanismActive()) {
                MekanismInteraction.registerPureOreRecipeInjectors(helper);
            }
            if (ECInteractions.isImmersiveEngineeringActive()) {
                IEInteraction.registerPureOreRecipeInjectors(helper);
            }
        });
    }

    public static <T extends AbstractCookingRecipe> void registerCooking(RegisterEvent.RegisterHelper<IPureOreRecipeFactoryType<?, ? extends Recipe<?>>> registry, RecipeType<T> recipeType, PureOreCookingRecipeFactory.Factory<T> factory) {
        PureOreRecipeFactoryTypes.register(registry, recipeType, (RecipeManager m) -> new PureOreCookingRecipeFactory(m, recipeType, factory));
    }

    public static <C extends RecipeInput, T extends Recipe<C>> void register(RegisterEvent.RegisterHelper<IPureOreRecipeFactoryType<?, ? extends Recipe<?>>> registry, RecipeType<?> recipeType, IPureOreRecipeFactoryType<C, T> type) {
        ResourceLocation id = BuiltInRegistries.RECIPE_TYPE.getKey(recipeType);
        if (id == null) {
            throw new PureOreException("Cannot register factory as its RecipeType is absent in registry.");
        }
        PureOreRecipeFactoryTypes.register(registry, id, type);
    }

    public static <C extends RecipeInput, T extends Recipe<C>> void register(RegisterEvent.RegisterHelper<IPureOreRecipeFactoryType<?, ? extends Recipe<?>>> registry, ResourceLocation id, IPureOreRecipeFactoryType<C, T> type) {
        String namespace = id.getNamespace();
        String path = id.getPath();
        PureOreRecipeFactoryTypes.register(registry, (String)("elementalcraft".equals(namespace) ? path : namespace + "/" + path), type);
    }

    public static <C extends RecipeInput, T extends Recipe<C>> void register(RegisterEvent.RegisterHelper<IPureOreRecipeFactoryType<?, ? extends Recipe<?>>> registry, String name, IPureOreRecipeFactoryType<C, T> type) {
        RegistryHelper.register(registry, type, name);
    }

    public static void register(IEventBus modBus) {
        DEFERRED_REGISTER.register(modBus);
    }
}

