/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore.factory;

import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.pureore.factory.AbstractPureOreRecipeFactory;
import sirttas.elementalcraft.tag.ECTags;

public class PureOreCookingRecipeFactory<T extends AbstractCookingRecipe>
extends AbstractPureOreRecipeFactory<SingleRecipeInput, T> {
    private final Factory<T> factory;

    public PureOreCookingRecipeFactory(RecipeManager recipeManager, RecipeType<T> recipeType, Factory<T> factory) {
        super(recipeManager, recipeType);
        this.factory = factory;
    }

    @Override
    public T create(@NotNull RegistryAccess registry, @NotNull T recipe, @NotNull Ingredient ingredient) {
        return this.factory.create(recipe.getGroup(), recipe.category(), ingredient, this.getRecipeOutput(registry, recipe), recipe.getExperience(), recipe.getCookingTime());
    }

    @Override
    public boolean filter(RecipeHolder<T> holder, ItemStack stack) {
        return super.filter(holder, stack) && (stack.is(ECTags.Items.PURE_ORES_SOURCES_ORES) || stack.is(ECTags.Items.PURE_ORES_SPECIFICS));
    }

    public static interface Factory<T extends AbstractCookingRecipe> {
        public T create(String var1, CookingBookCategory var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

