/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore.display;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.SessionSearchTrees;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.pureore.PureOre;
import sirttas.elementalcraft.pureore.display.PureOreDisplay;

@OnlyIn(value=Dist.CLIENT)
public class PureOreDisplayManager {
    private static final SessionSearchTrees.Key SEARCH_TREE_RELOAD_KEY = new SessionSearchTrees.Key();
    private static final PureOreDisplayManager INSTANCE = new PureOreDisplayManager();
    private final Map<ResourceLocation, PureOreDisplay> pureOreDisplays = new HashMap<ResourceLocation, PureOreDisplay>();

    private PureOreDisplayManager() {
    }

    public static PureOreDisplayManager getInstance() {
        return INSTANCE;
    }

    public void regenerate(Map<ResourceLocation, PureOre> pureOres) {
        ClientPacketListener clientpacketlistener = Minecraft.getInstance().getConnection();
        if (clientpacketlistener == null) {
            this.doRegenerate(pureOres);
            return;
        }
        clientpacketlistener.searchTrees().register(SEARCH_TREE_RELOAD_KEY, () -> this.doRegenerate(pureOres));
    }

    private void doRegenerate(Map<ResourceLocation, PureOre> pureOres) {
        this.pureOreDisplays.clear();
        for (Map.Entry<ResourceLocation, PureOre> entry : pureOres.entrySet()) {
            ResourceLocation id = entry.getKey();
            PureOre pureOre = entry.getValue();
            this.pureOreDisplays.put(id, new PureOreDisplay(id, pureOre));
        }
    }

    @Nullable
    public Component getPureOreName(@Nonnull ItemStack stack) {
        PureOreDisplay display = this.getPureOreDisplay(stack);
        return display != null ? display.name() : null;
    }

    @Nullable
    public int[] getColors(@Nonnull ItemStack stack) {
        PureOreDisplay display = this.getPureOreDisplay(stack);
        return display != null ? display.colors() : null;
    }

    @Nullable
    private PureOreDisplay getPureOreDisplay(@NotNull ItemStack stack) {
        ResourceLocation id = PureOre.getId(stack);
        if (id == null) {
            return null;
        }
        return this.pureOreDisplays.get(id);
    }
}

