/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore.display;

import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sirttas.elementalcraft.color.ECColorHelper;
import sirttas.elementalcraft.pureore.PureOre;

@OnlyIn(value=Dist.CLIENT)
public record PureOreDisplay(Component name, int[] colors) {
    public PureOreDisplay(ResourceLocation id, PureOre pureOre) {
        this(PureOreDisplay.loadPureOreName(id, pureOre), PureOreDisplay.loadPureOreColors(pureOre));
    }

    private static Component loadPureOreName(ResourceLocation id, PureOre pureOre) {
        String translationKey = "tooltip.elementalcraft.pure_ore." + id.getNamespace() + "." + id.getPath();
        if (Language.getInstance().has(translationKey)) {
            return Component.translatable((String)translationKey);
        }
        return (Component)pureOre.items().stream().map(holder -> Component.translatable((String)"tooltip.elementalcraft.pure_ore", (Object[])new Object[]{((Item)holder.value()).getDescription()})).findFirst().orElseGet(() -> Component.literal((String)"ERROR no name"));
    }

    private static int[] loadPureOreColors(PureOre pureOre) {
        return pureOre.resultsForColor().stream().map(ECColorHelper::lookupColors).findFirst().orElse(null);
    }
}

