/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.network.payload.PayloadHelper;
import sirttas.elementalcraft.pureore.PureOre;
import sirttas.elementalcraft.pureore.PureOreManager;
import sirttas.elementalcraft.pureore.display.PureOreDisplayManager;

public record PureOreSyncPayload(Map<ResourceLocation, PureOre> pureOres) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PureOreSyncPayload> TYPE = PayloadHelper.createType("pure_ore_sync");
    public static final StreamCodec<RegistryFriendlyByteBuf, PureOreSyncPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, (StreamCodec)StreamCodec.of(FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::readResourceLocation), PureOre.STREAM_CODEC), PureOreSyncPayload::pureOres, PureOreSyncPayload::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext payloadContext) {
        payloadContext.enqueueWork(() -> {
            Player player = payloadContext.player();
            MinecraftServer server = player.getServer();
            if (server == null || !server.isSingleplayerOwner(player.getGameProfile())) {
                PureOreManager.getInstance().replacePureOres(this.pureOres);
            }
            PureOreDisplayManager.getInstance().regenerate(this.pureOres);
            ElementalCraftApi.LOGGER.info("Pure ores synced to client.");
        });
    }
}

