/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.pureore;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.util.Supplier;
import org.jetbrains.annotations.Nullable;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.pureore.PureOreException;
import sirttas.elementalcraft.api.pureore.factory.IPureOreRecipeFactory;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.pureore.PureOre;
import sirttas.elementalcraft.pureore.PureOreManager;
import sirttas.elementalcraft.pureore.PureOreSyncPayload;
import sirttas.elementalcraft.pureore.factory.PureOreRecipeFactoryTypes;
import sirttas.elementalcraft.pureore.loader.IPureOreLoader;
import sirttas.elementalcraft.pureore.loader.LoadedPureOre;
import sirttas.elementalcraft.recipe.instrument.io.purification.OrePurificationRecipe;

@EventBusSubscriber(modid="elementalcraft")
public class PureOreGenerator {
    private PureOreGenerator() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void reload(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PureOreSyncPayload(PureOreManager.getInstance().getPureOres()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        new PureOreGenerator().reload(event.getPlayerList().getServer());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void reload(ServerStartedEvent event) {
        new PureOreGenerator().reload(event.getServer());
    }

    public void reload(MinecraftServer server) {
        Instant start = Instant.now();
        RecipeManager recipeManager = server.getRecipeManager();
        Collection<IPureOreRecipeFactory<?, Recipe<?>>> factories = this.createFactories(recipeManager);
        RegistryAccess.Frozen registry = server.registryAccess();
        HashMap pureOreSets = new HashMap();
        ElementalCraftApi.LOGGER.info("Pure ore generation started.\n\r\tRecipe Types: {}", new Supplier[]{() -> factories.stream().map(Object::toString).collect(Collectors.joining(", "))});
        ElementalCraft.PURE_ORE_LOADERS_MANAGER.holders().sorted(Comparator.comparingInt(holder -> ((IPureOreLoader)holder.value()).getOrder())).forEach(holder -> ((IPureOreLoader)holder.value()).generate((RegistryAccess)registry).forEach(e -> {
            factories.forEach(factory -> this.addRecipes((LoadedPureOre)e, (IPureOreRecipeFactory)factory, (RegistryAccess)registry));
            pureOreSets.computeIfAbsent(e.getId(), (Function<ResourceLocation, LoadedPureOreSet>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$reload$3(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lsirttas/elementalcraft/pureore/PureOreGenerator$LoadedPureOreSet;)()).ores.put((Holder<IPureOreLoader>)holder, (LoadedPureOre)e);
        }));
        pureOreSets.values().removeIf(o -> !o.isProcessable());
        Map<ResourceLocation, PureOre> pureOres = pureOreSets.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((LoadedPureOreSet)e.getValue()).toPureOre()));
        PureOreManager.getInstance().replacePureOres(pureOres);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new PureOreSyncPayload(pureOres), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (Boolean.TRUE.equals(ECConfig.SERVER.pureOreRecipeInjection.get())) {
            ElementalCraftApi.LOGGER.info("Building pure ore recipes.");
            List loadedPureOreSets = pureOreSets.values().stream().distinct().toList();
            List<RecipeHolder> recipes = recipeManager.getRecipes().stream().filter(r -> !this.isPureOreRecipe((RecipeHolder<?>)r)).toList();
            List<RecipeHolder> processingRecipes = factories.stream().mapMulti((factory, downstream) -> this.buildRecipes((RegistryAccess)registry, (IPureOreRecipeFactory)factory, loadedPureOreSets).forEach((Consumer)downstream)).filter(ElementalCraftUtils.distinctBy(RecipeHolder::id)).toList();
            List orePurificationRecipes = pureOreSets.entrySet().stream().mapMulti((entry, consumer) -> ((LoadedPureOreSet)entry.getValue()).getOrePurificationRecipes((ResourceLocation)entry.getKey()).forEach(consumer)).toList();
            ElementalCraftApi.LOGGER.info("Injecting pure ore recipes.");
            recipeManager.replaceRecipes(Iterables.concat(recipes, processingRecipes, orePurificationRecipes));
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = processingRecipes::size;
            supplierArray[1] = orePurificationRecipes::size;
            ElementalCraftApi.LOGGER.info("Pure ore recipe injection finished: {} processing recipes added and {} ore purification added.", supplierArray);
        }
        ElementalCraftApi.LOGGER.info("Pure ore generation ended in {}ms\r\n\tOres: {}.", new Supplier[]{() -> Duration.between(start, Instant.now()).toMillis(), () -> pureOreSets.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(", "))});
    }

    private Collection<? extends IPureOreRecipeFactory<?, ? extends Recipe<?>>> createFactories(@Nonnull RecipeManager recipeManager) {
        return PureOreRecipeFactoryTypes.REGISTRY.stream().map(t -> t.create(recipeManager)).toList();
    }

    private <C extends RecipeInput, T extends Recipe<C>> void addRecipes(LoadedPureOre ore, IPureOreRecipeFactory<C, T> factory, RegistryAccess registry) {
        factory.getRecipes(ore.getOres()).forEach(h -> {
            Recipe recipe = h.value();
            ore.addRecipe(recipe, factory.getRecipeOutput(registry, recipe));
        });
    }

    private boolean isPureOreRecipe(RecipeHolder<?> holder) {
        ResourceLocation id = holder.id();
        return id.getNamespace().equals("elementalcraft") && (id.getPath().startsWith("pure_ore/") || id.getPath().startsWith("ore_purification/generated/"));
    }

    private <C extends RecipeInput, T extends Recipe<C>> Stream<RecipeHolder<T>> buildRecipes(@Nonnull RegistryAccess registry, @Nonnull IPureOreRecipeFactory<C, T> factory, @Nonnull List<LoadedPureOreSet> entries) {
        return entries.stream().distinct().mapMulti((set, downstream) -> set.ores.values().forEach(v -> downstream.accept(this.buildRecipe(registry, factory, (LoadedPureOre)v)))).filter(Objects::nonNull);
    }

    private <C extends RecipeInput, T extends Recipe<C>> RecipeHolder<T> buildRecipe(@Nonnull RegistryAccess registry, @Nonnull IPureOreRecipeFactory<C, T> factory, @Nonnull LoadedPureOre entry) {
        RecipeType<T> recipeType = factory.getRecipeType();
        ResourceLocation key = BuiltInRegistries.RECIPE_TYPE.getKey(factory.getRecipeType());
        if (key == null) {
            throw new PureOreException("Cannot build pure ore recipe as its RecipeType is absent in registry.");
        }
        try {
            T recipe = entry.getRecipe(recipeType);
            ResourceLocation id = entry.getId();
            return recipe != null ? new RecipeHolder(PureOreGenerator.buildRecipeId(key, id), factory.create(registry, recipe, DataComponentIngredient.of((boolean)true, (ItemStack)PureOreManager.getInstance().createPureOre(id)))) : null;
        }
        catch (Exception e) {
            ElementalCraftApi.LOGGER.error("Error building pure ore recipe", (Throwable)e);
            return null;
        }
    }

    private static ResourceLocation buildRecipeId(@Nonnull ResourceLocation factoryId, @Nonnull ResourceLocation sourceId) {
        return ElementalCraftApi.createRL("pure_ore/" + factoryId.getNamespace() + "/" + factoryId.getPath() + "/" + sourceId.getNamespace() + "/" + sourceId.getPath());
    }

    private static /* synthetic */ LoadedPureOreSet lambda$reload$3(ResourceLocation i) {
        return new LoadedPureOreSet();
    }

    private static class LoadedPureOreSet {
        private final Map<Holder<IPureOreLoader>, LoadedPureOre> ores = new Reference2ObjectArrayMap(ElementalCraft.PURE_ORE_LOADERS_MANAGER.getData().size());

        public boolean isProcessable() {
            return !this.ores.isEmpty() && this.ores.values().stream().anyMatch(LoadedPureOre::isProcessable);
        }

        public List<RecipeHolder<OrePurificationRecipe>> getOrePurificationRecipes(ResourceLocation pureOreId) {
            return this.ores.entrySet().stream().map(entry -> new RecipeHolder(LoadedPureOreSet.buildOrePurificationRecipeId((ResourceKey<IPureOreLoader>)((Holder)entry.getKey()).getKey(), pureOreId), (Recipe)((LoadedPureOre)entry.getValue()).getOrePurificationRecipe())).toList();
        }

        private static ResourceLocation buildOrePurificationRecipeId(@Nullable ResourceKey<IPureOreLoader> loaderKey, @Nonnull ResourceLocation sourceId) {
            if (loaderKey == null) {
                ElementalCraftApi.LOGGER.warn("Unknown loader for pure ore {}.", (Object)sourceId);
                return ElementalCraftApi.createRL("ore_purification/generated/unknown_loader/" + sourceId.getNamespace() + "/" + sourceId.getPath());
            }
            ResourceLocation loaderId = loaderKey.location();
            return ElementalCraftApi.createRL("ore_purification/generated/" + loaderId.getNamespace() + "/" + loaderId.getPath() + "/" + sourceId.getNamespace() + "/" + sourceId.getPath());
        }

        public PureOre toPureOre() {
            HashSet<Holder<Item>> items = new HashSet<Holder<Item>>(this.ores.size());
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>(this.ores.size());
            ArrayList<ItemStack> resultsForColor = new ArrayList<ItemStack>(this.ores.size());
            for (LoadedPureOre ore : this.ores.values()) {
                items.addAll(ore.getOres());
                inputs.add(ore.getInput());
                if (ore.getResultForColor().isEmpty()) continue;
                resultsForColor.add(ore.getResultForColor());
            }
            return new PureOre(items, inputs, resultsForColor);
        }
    }
}

