/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.particle.element.source;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.particle.element.AbstractElementParticle;
import sirttas.elementalcraft.particle.element.ElementParticleData;

@OnlyIn(value=Dist.CLIENT)
public class SourceParticle
extends AbstractElementParticle {
    public static final ParticleEngine.SpriteParticleRegistration<ElementParticleData> FACTORY = s -> (data, level, x, y, z, xSpeed, ySpeed, zSpeed) -> new SourceParticle(level, new Vec3(x, y, z), s, data.getElementType());

    protected SourceParticle(ClientLevel level, Vec3 coord, SpriteSet sprite, ElementType type) {
        super(level, coord, type);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.xo = this.coordX;
        this.yo = this.coordY;
        this.zo = this.coordZ;
        this.x = this.xo;
        this.y = this.yo;
        this.z = this.zo;
        this.quadSize = 0.5f * (this.random.nextFloat() * 0.2f + 0.5f);
        this.hasPhysics = false;
        this.lifetime = 300;
        this.pickSprite(sprite);
    }

    public void tick() {
        if (this.checkLife()) {
            float f = (float)this.age / (float)this.lifetime;
            f = 1.0f - f;
            float f1 = 1.0f - f;
            f1 *= f1;
            f1 *= f1;
            this.x = this.coordX + this.xd * (double)f;
            this.y = this.coordY + this.yd * (double)f;
            this.z = this.coordZ + this.zd * (double)f;
            this.quadSize *= f - f1 * 1.2f;
        }
    }
}

