/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.particle.element;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.particle.element.AbstractElementParticle;
import sirttas.elementalcraft.particle.element.ElementParticleData;

@OnlyIn(value=Dist.CLIENT)
public class ElementCraftingParticle
extends AbstractElementParticle {
    public static final ParticleEngine.SpriteParticleRegistration<ElementParticleData> FACTORY = s -> (data, level, x, y, z, xSpeed, ySpeed, zSpeed) -> new ElementCraftingParticle(level, new Vec3(x, y, z), s, data.getElementType());

    private ElementCraftingParticle(ClientLevel level, Vec3 coord, SpriteSet sprite, ElementType type) {
        super(level, coord, type);
        this.xd = this.random.nextFloat() - 0.5f;
        this.yd = this.random.nextFloat() - 0.5f;
        this.zd = this.random.nextFloat() - 0.5f;
        this.xo = this.coordX + this.xd;
        this.yo = this.coordY + this.yd;
        this.zo = this.coordZ + this.zd;
        this.x = this.xo;
        this.y = this.yo;
        this.z = this.zo;
        this.usingDefaultSize();
        this.lifetime = this.random.nextInt(10) + 5;
        this.pickSprite(sprite);
    }

    public void tick() {
        if (this.checkLife()) {
            float f = (float)this.age / (float)this.lifetime;
            f = 1.0f - f;
            this.x = this.coordX + this.xd * (double)f;
            this.y = this.coordY + this.yd * (double)f;
            this.z = this.coordZ + this.zd * (double)f;
        }
    }
}

