/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.particle;

import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.particle.ECParticles;
import sirttas.elementalcraft.particle.element.ElementParticleData;

public class ParticleHelper {
    private ParticleHelper() {
    }

    public static void createSourceParticle(ElementType type, Level level, Vec3 pos, RandomSource rand) {
        double x = pos.x() + (rand.nextDouble() * 2.0 - 1.0) / 16.0;
        double y = pos.y() - 0.1875;
        double z = pos.z() + (rand.nextDouble() * 2.0 - 1.0) / 16.0;
        ParticleHelper.addParticle(level, new ElementParticleData((ParticleType<ElementParticleData>)((ParticleType)ECParticles.SOURCE.get()), type), x, y, z, 0.0, 0.0, 0.0);
    }

    public static void createCraftingParticle(ElementType type, Level level, Vec3 pos, RandomSource rand) {
        double x = pos.x() + (rand.nextDouble() * 2.0 - 1.0) / 16.0;
        double y = pos.y() - 0.1875;
        double z = pos.z() + (rand.nextDouble() * 2.0 - 1.0) / 16.0;
        IntStream.range(0, 8 + rand.nextInt(5)).forEach(i -> ParticleHelper.addParticle(level, new ElementParticleData((ParticleType<ElementParticleData>)((ParticleType)ECParticles.ELEMENT_CRAFTING.get()), type != ElementType.NONE ? type : ElementType.random(rand)), x, y, z, 0.0, 0.0, 0.0));
    }

    public static void createElementFlowParticle(ElementType type, Level level, Vec3 end, Direction direction, float scale, RandomSource rand) {
        ParticleHelper.createElementFlowParticle(type, level, end, Vec3.atLowerCornerOf((Vec3i)direction.getOpposite().getNormal()).scale(scale <= 0.0f ? 1.0 : (double)scale), new Vec3(3.0, 3.0, 3.0), rand);
    }

    public static void createElementFlowParticle(ElementType type, Level level, Vec3 start, Vec3 end, RandomSource rand) {
        ParticleHelper.createElementFlowParticle(type, level, end, start.subtract(end), new Vec3(1.0, 1.0, 1.0), rand);
    }

    private static void createElementFlowParticle(ElementType type, Level level, Vec3 end, Vec3 flow, Vec3 radius, RandomSource rand) {
        double x = end.x() + (2.0 * rand.nextDouble() - 1.0) * radius.x() / 16.0;
        double y = end.y() + (2.0 * rand.nextDouble() - 1.0) * radius.y() / 16.0;
        double z = end.z() + (2.0 * rand.nextDouble() - 1.0) * radius.z() / 16.0;
        ParticleHelper.addParticle(level, new ElementParticleData((ParticleType<ElementParticleData>)((ParticleType)ECParticles.ELEMENT_FLOW.get()), type), x, y, z, flow.x(), flow.y(), flow.z());
    }

    public static void createEnderParticle(Level level, Vec3 pos, int count, RandomSource rand) {
        for (int i = 0; i < count; ++i) {
            int j = rand.nextInt(2) * 2 - 1;
            int k = rand.nextInt(2) * 2 - 1;
            double d0 = pos.x() + 0.5 + 0.25 * (double)j;
            double d1 = pos.y() + (double)rand.nextFloat();
            double d2 = pos.z() + 0.5 + 0.25 * (double)k;
            double d3 = rand.nextFloat() * (float)j;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.125;
            double d5 = rand.nextFloat() * (float)k;
            ParticleHelper.addParticle(level, (ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void createItemBreakParticle(Level level, Vec3 pos, RandomSource rand, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 speed = new Vec3(0.0, rand.nextDouble() * 0.1 + 0.1, 0.0);
            Vec3 loc = pos.add(0.0, rand.nextDouble() * 0.2 - 0.2, 0.0);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), loc.x, loc.y, loc.z, 1, speed.x, speed.y + 0.05, speed.z, 0.0);
                continue;
            }
            level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), loc.x, loc.y, loc.z, speed.x, speed.y + 0.05, speed.z);
        }
    }

    private static void addParticle(Level level, ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles(particleData, x, y, z, 0, xSpeed, ySpeed, zSpeed, 1.0);
        } else {
            level.addParticle(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

