/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.particle;

import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import sirttas.elementalcraft.particle.element.ElementCraftingParticle;
import sirttas.elementalcraft.particle.element.ElementFlowParticle;
import sirttas.elementalcraft.particle.element.ElementParticleData;
import sirttas.elementalcraft.particle.element.source.SourceParticle;

@EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft", bus=EventBusSubscriber.Bus.MOD)
public class ECParticles {
    private static final DeferredRegister<ParticleType<?>> DEFERRED_REGISTER = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"elementalcraft");
    public static final DeferredHolder<ParticleType<?>, ParticleType<ElementParticleData>> SOURCE = ECParticles.register(() -> ElementParticleData.createParticleType(true), "source");
    public static final DeferredHolder<ParticleType<?>, ParticleType<ElementParticleData>> ELEMENT_FLOW = ECParticles.register(() -> ElementParticleData.createParticleType(false), "element_flow");
    public static final DeferredHolder<ParticleType<?>, ParticleType<ElementParticleData>> ELEMENT_CRAFTING = ECParticles.register(() -> ElementParticleData.createParticleType(false), "elementcrafting");

    private ECParticles() {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerFactories(RegisterParticleProvidersEvent evt) {
        evt.registerSpriteSet((ParticleType)SOURCE.get(), SourceParticle.FACTORY);
        evt.registerSpriteSet((ParticleType)ELEMENT_FLOW.get(), ElementFlowParticle.FACTORY);
        evt.registerSpriteSet((ParticleType)ELEMENT_CRAFTING.get(), ElementCraftingParticle.FACTORY);
    }

    private static <O extends ParticleOptions, T extends ParticleType<O>> DeferredHolder<ParticleType<?>, T> register(Supplier<T> type, String name) {
        return DEFERRED_REGISTER.register(name, type);
    }

    public static void register(IEventBus bus) {
        DEFERRED_REGISTER.register(bus);
    }
}

