/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.mixin;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.jewel.HawkJewel;
import sirttas.elementalcraft.jewel.JewelHelper;
import sirttas.elementalcraft.jewel.Jewels;

@Mixin(value={Projectile.class})
public abstract class MixinProjectile
extends Entity {
    @Unique
    private boolean homing = false;
    @Unique
    private double maxReachedSpeed = -1.0;
    @Shadow
    private boolean hasBeenShot;

    @Shadow
    public abstract Entity getOwner();

    protected MixinProjectile(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tick$head(CallbackInfo ci) {
        this.handleHoming();
    }

    @Unique
    private void handleHoming() {
        Entity owner;
        MixinProjectile mixinProjectile = this;
        if (mixinProjectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)mixinProjectile;
            if (arrow.inGround) {
                return;
            }
        }
        if ((owner = this.getOwner()) == null) {
            return;
        }
        HawkJewel hawk = (HawkJewel)Jewels.HAWK.get();
        if (!this.hasBeenShot && JewelHelper.hasJewel(owner, hawk)) {
            this.homing = true;
            if (!this.level().isClientSide) {
                hawk.consume(owner);
            }
            return;
        }
        if (!this.homing) {
            return;
        }
        HitResult hit = EntityHelper.rayTrace(owner, 100.0);
        if (hit.getType() == HitResult.Type.MISS) {
            return;
        }
        this.setHomingTo(hit.getLocation());
    }

    @Unique
    private void setHomingTo(Vec3 target) {
        Vec3 oldDelta = this.getDeltaMovement();
        double length = oldDelta.length();
        Vec3 targetVector = target.subtract(this.position()).normalize();
        Vec3 normalizedDelta = oldDelta.normalize();
        this.maxReachedSpeed = Math.max(this.maxReachedSpeed, length);
        length = Math.acos(normalizedDelta.dot(targetVector)) > 0.19634954084936207 ? (length *= 0.995) : Math.min(length * 1.005, this.maxReachedSpeed);
        this.setDeltaMovement(targetVector.add(normalizedDelta).normalize().scale(length));
    }
}

