/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.api.data.DataManagerCodecs;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.loot.function.ECLootFunctions;

public class SetRuneFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetRuneFunction> CODEC = RecordCodecBuilder.mapCodec(builder -> SetRuneFunction.commonFields((RecordCodecBuilder.Instance)builder).and((App)DataManagerCodecs.holderCodec(ElementalCraftApi.RUNE_MANAGER_KEY, Rune.CODEC, (boolean)false).fieldOf("rune").forGetter(r -> r.rune)).apply((Applicative)builder, SetRuneFunction::new));
    private final Holder<Rune> rune;

    private SetRuneFunction(List<LootItemCondition> condition, Holder<Rune> rune) {
        super(condition);
        this.rune = rune;
    }

    @Nonnull
    public ItemStack run(@Nonnull ItemStack stack, @NotNull LootContext context) {
        stack.set(ECDataComponents.RUNE, this.rune);
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder(Holder<Rune> rune) {
        return SetRuneFunction.simpleBuilder(l -> new SetRuneFunction((List<LootItemCondition>)l, rune));
    }

    @Nonnull
    public LootItemFunctionType<SetRuneFunction> getType() {
        return (LootItemFunctionType)ECLootFunctions.SET_RUNE.get();
    }
}

