/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import sirttas.elementalcraft.loot.function.ECLootFunctions;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;

public class RandomSpellListFunction
extends LootItemConditionalFunction {
    public static final MapCodec<RandomSpellListFunction> CODEC = RecordCodecBuilder.mapCodec(builder -> RandomSpellListFunction.commonFields((RecordCodecBuilder.Instance)builder).and((App)RegistryCodecs.homogeneousList(Spells.REGISTRY_KEY).fieldOf("spells").forGetter(r -> r.spellList)).apply((Applicative)builder, RandomSpellListFunction::new));
    private final HolderSet<Spell> spellList;

    private RandomSpellListFunction(List<LootItemCondition> condition, HolderSet<Spell> spellList) {
        super(condition);
        this.spellList = spellList;
    }

    @Nonnull
    public ItemStack run(@Nonnull ItemStack stack, LootContext context) {
        SpellHelper.setSpell(stack, SpellHelper.randomSpell(this.spellList, context.getRandom()));
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder(HolderSet<Spell> spellList) {
        return RandomSpellListFunction.simpleBuilder(l -> new RandomSpellListFunction((List<LootItemCondition>)l, spellList));
    }

    @Nonnull
    public LootItemFunctionType<RandomSpellListFunction> getType() {
        return (LootItemFunctionType)ECLootFunctions.RANDOM_SPELL_LIST.get();
    }
}

