/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.loot.function.ECLootFunctions;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;

public class RandomSpellFunction
extends LootItemConditionalFunction
implements IElementTypeProvider {
    public static final MapCodec<RandomSpellFunction> CODEC = RecordCodecBuilder.mapCodec(builder -> RandomSpellFunction.commonFields((RecordCodecBuilder.Instance)builder).and((App)ElementType.CODEC.optionalFieldOf("element_type", (Object)ElementType.NONE).forGetter(RandomSpellFunction::getElementType)).apply((Applicative)builder, RandomSpellFunction::new));
    private final ElementType elementType;

    private RandomSpellFunction(List<LootItemCondition> condition, ElementType elementType) {
        super(condition);
        this.elementType = elementType;
    }

    @Nonnull
    public ItemStack run(@Nonnull ItemStack stack, LootContext context) {
        RandomSource random = context.getRandom();
        Holder<Spell> spell = this.elementType != ElementType.NONE ? SpellHelper.randomSpell(this.elementType, random) : SpellHelper.randomSpell(random);
        SpellHelper.setSpell(stack, spell);
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return RandomSpellFunction.builder(ElementType.NONE);
    }

    public static LootItemConditionalFunction.Builder<?> builder(ElementType elementType) {
        return RandomSpellFunction.simpleBuilder(l -> new RandomSpellFunction((List<LootItemCondition>)l, elementType));
    }

    @Nonnull
    public LootItemFunctionType<RandomSpellFunction> getType() {
        return (LootItemFunctionType)ECLootFunctions.RANDOM_SPELL.get();
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }
}

