/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot.entry;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.rune.RuneItem;
import sirttas.elementalcraft.loot.entry.ECLootPoolEntries;
import sirttas.elementalcraft.loot.parameter.ECLootContextParams;

public class LootRunes
extends LootPoolSingletonContainer {
    public static final MapCodec<LootRunes> CODEC = RecordCodecBuilder.mapCodec(builder -> LootRunes.singletonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, LootRunes::new));

    private LootRunes(int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(weight, quality, conditions, functions);
    }

    protected void createItemStack(@Nonnull Consumer<ItemStack> output, @Nonnull LootContext context) {
        BlockEntity be = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (be == null) {
            return;
        }
        IRuneHandler runeHandler = BlockEntityHelper.getCapability(ElementalCraftCapabilities.RuneHandler.BLOCK, be, (Direction)context.getParamOrNull(ECLootContextParams.DIRECTION));
        if (runeHandler == null) {
            return;
        }
        runeHandler.getRunes().forEach(rune -> output.accept(((RuneItem)ECItems.RUNE.get()).getRuneStack((Rune)rune)));
    }

    public static LootPoolSingletonContainer.Builder<?> builder() {
        return LootRunes.simpleBuilder(LootRunes::new);
    }

    @Nonnull
    public LootPoolEntryType getType() {
        return (LootPoolEntryType)ECLootPoolEntries.RUNES.get();
    }
}

