/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.enchantment.ECEnchantmentHelper;

public class LootHelper {
    private LootHelper() {
    }

    public static List<ItemStack> getDrops(ServerLevel level, BlockPos pos) {
        return LootHelper.getDrops(level, pos, ItemStack.EMPTY);
    }

    public static List<ItemStack> getDrops(ServerLevel level, BlockPos pos, boolean silkTouch) {
        if (silkTouch) {
            ItemStack stack = new ItemStack((ItemLike)Items.NETHERITE_PICKAXE);
            stack.enchant(ECEnchantmentHelper.getEnchantmentHolder(level.registryAccess(), (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH), 1);
            return LootHelper.getDrops(level, pos, stack);
        }
        return LootHelper.getDrops(level, pos);
    }

    public static List<ItemStack> getDrops(ServerLevel level, BlockPos pos, ItemStack stack) {
        BlockState state = level.getBlockState(pos);
        return state.getDrops(new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)stack));
    }
}

