/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import sirttas.elementalcraft.api.ElementalCraftApi;

@EventBusSubscriber(modid="elementalcraft")
public final class LootHandler {
    private static final ResourceKey<LootTable> CHEST_INJECT_KEY = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ElementalCraftApi.createRL("chests/inject"));
    private static final LootPool CHEST_INJECT = LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(CHEST_INJECT_KEY).setWeight(1)).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).name("elementalcraft_inject").build();
    private static final List<String> BLACKLIST = List.of("dispenser");

    private LootHandler() {
    }

    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent evt) {
        ResourceLocation name = evt.getName();
        if (name.toString().startsWith("minecraft:chests/")) {
            if (BLACKLIST.stream().anyMatch(name.toString()::contains)) {
                evt.getTable().addPool(CHEST_INJECT);
            }
        }
    }
}

