/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.enchantment.ECEnchantmentHelper;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;

public class FireInfusionLootModifier
extends LootModifier {
    public static final MapCodec<FireInfusionLootModifier> DIRECT_CODEC = RecordCodecBuilder.mapCodec(i -> FireInfusionLootModifier.codecStart((RecordCodecBuilder.Instance)i).apply((Applicative)i, FireInfusionLootModifier::new));

    protected FireInfusionLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    private ItemStack applyAutoSmelt(ItemStack stack, LootContext context) {
        ServerLevel level = context.getLevel();
        RegistryAccess registry = level.registryAccess();
        Optional<SmeltingRecipe> recipe = level.getRecipeManager().byType(RecipeType.SMELTING).stream().map(RecipeHolder::value).filter(r -> ((Ingredient)r.getIngredients().getFirst()).test(stack)).findFirst();
        if (recipe.isPresent()) {
            ItemStack ret = recipe.get().getResultItem((HolderLookup.Provider)registry).copy();
            ret.setCount(ret.getCount() * stack.getCount());
            if (stack.is(Tags.Items.ORES)) {
                ApplyBonusCount.addUniformBonusCount(ECEnchantmentHelper.getEnchantmentHolder(registry, (ResourceKey<Enchantment>)Enchantments.FORTUNE)).build().apply((Object)ret, (Object)context);
            }
            return ret;
        }
        return stack;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack tool = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
        if (tool != null && !tool.isEmpty() && ToolInfusionHelper.hasAutoSmelt(tool)) {
            return generatedLoot.stream().map(s -> this.applyAutoSmelt((ItemStack)s, context)).collect(Collectors.toCollection(ObjectArrayList::new));
        }
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return DIRECT_CODEC;
    }
}

