/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel.handler;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.projectile.Projectile;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.InfiniteElementStorage;
import sirttas.elementalcraft.attributes.AttributesHelper;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.JewelHelper;
import sirttas.elementalcraft.jewel.attack.AbstractAttackJewel;
import sirttas.elementalcraft.jewel.defence.DefenceJewel;
import sirttas.elementalcraft.jewel.effect.EffectJewel;
import sirttas.elementalcraft.jewel.handler.ActiveJewelsPayload;
import sirttas.elementalcraft.jewel.handler.IJewelHandler;
import sirttas.elementalcraft.tag.ECTags;

@EventBusSubscriber(modid="elementalcraft")
public class JewelHandler
implements IJewelHandler {
    private final Entity entity;
    private List<Jewel> activeJewels;
    private Multimap<Holder<Attribute>, AttributeModifier> oldAttributes;

    public JewelHandler(Entity entity) {
        this.entity = entity;
        this.activeJewels = new ArrayList<Jewel>();
    }

    @Override
    @Nonnull
    public List<Jewel> getActiveJewels() {
        return List.copyOf(this.activeJewels);
    }

    public void tick() {
        IElementStorage elementStorage = (IElementStorage)this.entity.getCapability(ElementalCraftCapabilities.ElementStorage.ENTITY);
        if (elementStorage == null) {
            elementStorage = InfiniteElementStorage.INSTANCE;
        }
        ArrayList<Jewel> jewels = new ArrayList<Jewel>();
        for (Jewel jewel : JewelHelper.getAllJewels(this.entity)) {
            if (!jewel.isActive(this.entity, elementStorage)) continue;
            jewels.add(jewel);
            if (!jewel.isTicking()) continue;
            jewel.consume(this.entity, elementStorage);
            if (!(jewel instanceof EffectJewel)) continue;
            EffectJewel effectJewel = (EffectJewel)jewel;
            Entity entity = this.entity;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            effectJewel.apply(livingEntity);
        }
        jewels.sort(Comparator.comparing(Jewel::getKey));
        if (!jewels.equals(this.activeJewels)) {
            this.activeJewels = jewels;
            this.onActiveJewelsChanged();
        }
    }

    private void onActiveJewelsChanged() {
        this.reloadAttributes();
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ActiveJewelsPayload(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void reloadAttributes() {
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Multimap<Holder<Attribute>, AttributeModifier> attributes = JewelHelper.getJewelsAttribute(this.entity);
            AttributeMap attributeMap = livingEntity.getAttributes();
            if (this.oldAttributes != null) {
                AttributesHelper.removeAttributes(attributeMap, this.oldAttributes);
            }
            AttributesHelper.addAttributes(attributeMap, attributes);
            this.oldAttributes = attributes;
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(@Nonnull LivingDamageEvent.Pre event) {
        DamageSource source = event.getSource();
        if (source.is(ECTags.DamageTypes.BYPASSES_DEFENSE_JEWELS)) {
            return;
        }
        LivingEntity target = event.getEntity();
        for (Jewel jewel : JewelHelper.getActiveJewels((Entity)target)) {
            if (!(jewel instanceof DefenceJewel)) continue;
            DefenceJewel defenceJewel = (DefenceJewel)jewel;
            event.setNewDamage(defenceJewel.onHurt((Entity)target, source, event.getNewDamage()));
            if (jewel.isTicking()) continue;
            jewel.consume((Entity)target);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(@Nonnull LivingDamageEvent.Post event) {
        DamageSource source = event.getSource();
        if (source.is(ECTags.DamageTypes.BYPASSES_ATTACK_JEWELS)) {
            return;
        }
        LivingEntity target = event.getEntity();
        Entity attacker = source.getEntity();
        if (attacker instanceof Projectile) {
            Projectile projectile = (Projectile)attacker;
            attacker = projectile.getOwner();
        }
        if (attacker != null) {
            for (Jewel jewel : JewelHelper.getActiveJewels(attacker)) {
                if (!(jewel instanceof AbstractAttackJewel)) continue;
                AbstractAttackJewel attackJewel = (AbstractAttackJewel)jewel;
                attackJewel.onAttack(attacker, target);
                if (jewel.isTicking()) continue;
                jewel.consume(attacker);
            }
        }
    }
}

