/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel.handler;

import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.JewelHelper;
import sirttas.elementalcraft.jewel.handler.IJewelHandler;

@EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft")
public class ClientJewelHandler
implements IJewelHandler {
    private List<Jewel> activeJewels = Collections.emptyList();

    @Override
    @Nonnull
    public List<Jewel> getActiveJewels() {
        return this.activeJewels;
    }

    @SubscribeEvent
    public static void addJewelTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        Jewel jewel = JewelHelper.getJewel(stack);
        if (jewel != null) {
            int index = IntStream.range(0, tooltip.size()).filter(i -> BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().equals(((Component)tooltip.get(i)).getString())).findFirst().orElse(tooltip.size());
            Component component = jewel.getDisplayName();
            if (component instanceof MutableComponent) {
                MutableComponent mutableComponent = (MutableComponent)component;
                component = mutableComponent.withStyle(ChatFormatting.YELLOW);
            }
            tooltip.add(index, component);
        }
    }

    public void setActiveJewels(List<Jewel> jewels) {
        this.activeJewels = List.copyOf(jewels);
    }
}

