/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel.handler;

import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.Jewels;
import sirttas.elementalcraft.jewel.handler.ClientJewelHandler;
import sirttas.elementalcraft.jewel.handler.IJewelHandler;
import sirttas.elementalcraft.network.payload.PayloadHelper;

public record ActiveJewelsPayload(List<ResourceLocation> jewels) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ActiveJewelsPayload> TYPE = PayloadHelper.createType("active_jewels");
    public static final StreamCodec<FriendlyByteBuf, ActiveJewelsPayload> STREAM_CODEC = StreamCodec.of((b, p) -> p.write((FriendlyByteBuf)b), ActiveJewelsPayload::new);

    public ActiveJewelsPayload(IJewelHandler jewelHandler) {
        this(jewelHandler.getActiveJewels().stream().map(Jewel::getKey).toList());
    }

    public ActiveJewelsPayload(FriendlyByteBuf buf) {
        this(buf.readList(FriendlyByteBuf::readResourceLocation));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeCollection(this.jewels, FriendlyByteBuf::writeResourceLocation);
    }

    @NotNull
    public CustomPacketPayload.Type<ActiveJewelsPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext payloadContext) {
        payloadContext.enqueueWork(() -> {
            Player player = payloadContext.player();
            Object patt0$temp = player.getCapability(IJewelHandler.CAPABILITY);
            if (patt0$temp instanceof ClientJewelHandler) {
                ClientJewelHandler handler = (ClientJewelHandler)patt0$temp;
                handler.setActiveJewels(this.jewels.stream().map(arg_0 -> Jewels.REGISTRY.get(arg_0)).toList());
            }
        });
    }
}

