/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel.effect;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.jewel.Jewel;

public class EffectJewel
extends Jewel {
    protected final List<MobEffectInstance> effects;

    public EffectJewel(ElementType elementType, int consumption, boolean ticking, MobEffectInstance ... effects) {
        super(elementType, consumption, ticking);
        this.effects = ImmutableList.copyOf((Object[])effects);
    }

    public void apply(LivingEntity entity) {
        for (MobEffectInstance effect : this.effects) {
            entity.addEffect(new MobEffectInstance(effect));
        }
    }

    @Override
    public boolean isActive(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        return this.isActive(entity, entity, elementStorage);
    }

    public boolean isActive(@Nonnull Entity entity, @Nonnull Entity target, @Nullable IElementStorage elementStorage) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            Collection activeEffects = livingTarget.getActiveEffects();
            if (this.effects.stream().allMatch(effect -> activeEffects.stream().anyMatch(activeEffect -> activeEffect.getEffect().equals((Object)effect.getEffect()) && activeEffect.getAmplifier() >= effect.getAmplifier() && activeEffect.getDuration() >= 2))) {
                return false;
            }
        }
        return super.isActive(entity, elementStorage);
    }
}

