/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel.effect;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.container.ECContainerHelper;
import sirttas.elementalcraft.jewel.JewelHelper;
import sirttas.elementalcraft.jewel.Jewels;
import sirttas.elementalcraft.jewel.effect.EffectJewel;

public class DemigodJewel
extends EffectJewel {
    public static final String NAME = "demigod";

    public DemigodJewel() {
        super(ElementType.AIR, 10000, false, new MobEffectInstance(MobEffects.REGENERATION, 900, 1), new MobEffectInstance(MobEffects.ABSORPTION, 100, 1), new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
    }

    public static boolean trigger(LivingEntity entity) {
        DemigodJewel demigod = (DemigodJewel)Jewels.DEMIGOD.get();
        if (!JewelHelper.hasJewel((Entity)entity, demigod)) {
            return false;
        }
        demigod.apply(entity);
        demigod.consume((Entity)entity);
        return true;
    }

    @Override
    public void apply(LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)Items.TOTEM_OF_UNDYING), 1);
            CriteriaTriggers.USED_TOTEM.trigger(serverPlayer, new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING));
        }
        entity.setHealth(1.0f);
        super.apply(entity);
        entity.level().broadcastEntityEvent((Entity)entity, (byte)35);
    }

    @Override
    public boolean isActive(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (super.isActive(entity, elementStorage)) {
                return ECContainerHelper.getSlotFor((Container)player.getInventory(), new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING)) >= 0;
            }
        }
        return false;
    }

    @Override
    public void consume(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        super.consume(entity, elementStorage);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Inventory inv = player.getInventory();
        int slot = ECContainerHelper.getSlotFor((Container)inv, new ItemStack((ItemLike)Items.TOTEM_OF_UNDYING));
        if (slot >= 0) {
            inv.setItem(slot, ItemStack.EMPTY);
        }
    }

    @Override
    public void appendHoverText(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.demigod").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(tooltip);
    }
}

