/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel.effect;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.CommonHooks;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.jewel.effect.EffectJewel;

public class BasiliskJewel
extends EffectJewel {
    public static final String NAME = "basilisk";

    public BasiliskJewel() {
        super(ElementType.WATER, 20, true, new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 2, 3), new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 2, 2));
    }

    private Entity getTarget(Entity entity) {
        HitResult hit = EntityHelper.rayTrace(entity);
        if (hit.getType() == HitResult.Type.ENTITY && hit instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hit;
            return entityHitResult.getEntity();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isActive(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        Entity target = this.getTarget(entity);
        if (target == null) {
            return false;
        }
        if (entity.isAlliedTo(target)) return false;
        if (!(target instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)target;
        if (!this.effects.stream().allMatch(effect -> CommonHooks.canMobEffectBeApplied((LivingEntity)livingEntity, (MobEffectInstance)effect))) return false;
        if (!super.isActive(entity, target, elementStorage)) return false;
        return true;
    }

    @Override
    public void apply(LivingEntity entity) {
        Entity target = this.getTarget((Entity)entity);
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            super.apply(livingEntity);
        }
    }

    @Override
    public void appendHoverText(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.basilisk").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(tooltip);
    }
}

