/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel.defence;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.jewel.defence.DefenceJewel;
import sirttas.elementalcraft.tag.ECTags;

public class TortoiseJewel
extends DefenceJewel {
    public static final String NAME = "tortoise";

    public TortoiseJewel() {
        super(ElementType.EARTH, 500, false);
    }

    @Override
    public float onHurt(Entity entity, DamageSource source, float amount) {
        Level level = entity.level();
        if (amount == 0.0f || !source.is(ECTags.DamageTypes.BLOCKED_BY_TORTOISE_JEWEL)) {
            return super.onHurt(entity, source, amount);
        }
        level.getEntitiesOfClass(FallingBlockEntity.class, entity.getBoundingBox()).forEach(e -> {
            e.discard();
            if (e.dropItem && level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                Block block = e.getBlockState().getBlock();
                e.callOnBrokenAfterFall(block, e.blockPosition());
                e.spawnAtLocation((ItemLike)block);
            }
        });
        return 0.0f;
    }

    @Override
    public void appendHoverText(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.tortoise").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(tooltip);
    }
}

