/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel.defence;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.jewel.defence.DefenceJewel;

public class ArcticHareJewel
extends DefenceJewel {
    public static final String NAME = "arctic_hare";

    public ArcticHareJewel() {
        super(ElementType.WATER, 10, true);
    }

    private boolean isOnSnow(Entity entity) {
        BlockPos blockpos = entity.getOnPos();
        BlockState blockstate = entity.level().getBlockState(blockpos);
        return blockstate.is(Blocks.POWDER_SNOW);
    }

    @Override
    public boolean isActive(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        return (entity.isInPowderSnow || entity.wasInPowderSnow || this.isOnSnow(entity)) && super.isActive(entity, elementStorage);
    }

    @Override
    public float onHurt(Entity entity, DamageSource source, float amount) {
        return source.is(DamageTypes.FREEZE) ? 0.0f : super.onHurt(entity, source, amount);
    }

    @Override
    public void appendHoverText(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.arctic_hare").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(tooltip);
    }
}

