/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel.attribute;

import com.google.common.collect.ImmutableMultimap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.jewel.attribute.AttributeJewel;

public class BearJewel
extends AttributeJewel {
    public static final String NAME = "bear";
    private static final ResourceLocation ATTACK_DAMAGE_ID = ElementalCraftApi.createRL("bear_jewel_attack_damage");
    private static final ResourceLocation ATTACK_KNOCKBACK_ID = ElementalCraftApi.createRL("bear_jewel_attack_knockback");

    public BearJewel() {
        super(ElementType.EARTH, 10, () -> {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ATTACK_DAMAGE_ID, 6.0, AttributeModifier.Operation.ADD_VALUE));
            builder.put((Object)Attributes.ATTACK_KNOCKBACK, (Object)new AttributeModifier(ATTACK_KNOCKBACK_ID, 2.0, AttributeModifier.Operation.ADD_VALUE));
            return builder.build();
        });
    }

    @Override
    public boolean isActive(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        return EntityHelper.isFighting(entity) && super.isActive(entity, elementStorage);
    }

    @Override
    protected Component getAttributesTitle() {
        return Component.translatable((String)"tooltip.elementalcraft.while_fighting").withStyle(ChatFormatting.GRAY);
    }
}

