/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.jewel.Jewel;

public class StriderJewel
extends Jewel {
    private final TagKey<Fluid> tag;

    public StriderJewel(ElementType elementType, int consumption, TagKey<Fluid> tag) {
        super(elementType, consumption, true);
        this.tag = tag;
    }

    private boolean isOnFluid(Entity entity) {
        BlockPos blockpos = entity.getOnPos();
        BlockState blockstate = entity.level().getBlockState(blockpos);
        return blockstate.getFluidState().is(this.tag);
    }

    @Override
    public boolean isActive(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        return this.isOnFluid(entity) && super.isActive(entity, elementStorage);
    }

    @Override
    public void appendHoverText(List<Component> tooltip) {
        ResourceLocation key = this.tag.location();
        tooltip.add((Component)Component.translatable((String)("tooltip.elementalcraft.strider." + key.getNamespace() + "." + key.getPath().replace("/", "."))).withStyle(ChatFormatting.BLUE));
        super.appendHoverText(tooltip);
    }

    public TagKey<Fluid> getTag() {
        return this.tag;
    }
}

