/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.item.jewel.JewelItem;
import sirttas.elementalcraft.jewel.HawkJewel;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.PiglinJewel;
import sirttas.elementalcraft.jewel.StriderJewel;
import sirttas.elementalcraft.jewel.attack.KirinJewel;
import sirttas.elementalcraft.jewel.attack.ViperJewel;
import sirttas.elementalcraft.jewel.attribute.BearJewel;
import sirttas.elementalcraft.jewel.attribute.DolphinJewel;
import sirttas.elementalcraft.jewel.attribute.LeopardJewel;
import sirttas.elementalcraft.jewel.attribute.TigerJewel;
import sirttas.elementalcraft.jewel.defence.ArcticHareJewel;
import sirttas.elementalcraft.jewel.defence.TortoiseJewel;
import sirttas.elementalcraft.jewel.effect.BasiliskJewel;
import sirttas.elementalcraft.jewel.effect.DemigodJewel;
import sirttas.elementalcraft.jewel.effect.PhoenixJewel;
import sirttas.elementalcraft.jewel.effect.SalmonJewel;
import sirttas.elementalcraft.jewel.effect.mole.MoleJewel;

public class Jewels {
    private static final Map<Jewel, Item> JEWEL_ITEM_MAP = new Object2ObjectOpenHashMap();
    public static final ResourceKey<Registry<Jewel>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ElementalCraftApi.createRL("jewel"));
    private static final DeferredRegister<Jewel> DEFERRED_REGISTER = DeferredRegister.create(REGISTRY_KEY, (String)"elementalcraft");
    public static final Registry<Jewel> REGISTRY = DEFERRED_REGISTER.makeRegistry(b -> b.sync(true).defaultKey(ElementalCraftApi.createRL("none")));
    public static final DeferredHolder<Jewel, SalmonJewel> SALMON = Jewels.register("salmon", SalmonJewel::new);
    public static final DeferredHolder<Jewel, PhoenixJewel> PHOENIX = Jewels.register("phoenix", PhoenixJewel::new);
    public static final DeferredHolder<Jewel, BasiliskJewel> BASILISK = Jewels.register("basilisk", BasiliskJewel::new);
    public static final DeferredHolder<Jewel, BearJewel> BEAR = Jewels.register("bear", BearJewel::new);
    public static final DeferredHolder<Jewel, TigerJewel> TIGER = Jewels.register("tiger", TigerJewel::new);
    public static final DeferredHolder<Jewel, LeopardJewel> LEOPARD = Jewels.register("leopard", LeopardJewel::new);
    public static final DeferredHolder<Jewel, DolphinJewel> DOLPHIN = Jewels.register("dolphin", DolphinJewel::new);
    public static final DeferredHolder<Jewel, KirinJewel> KIRIN = Jewels.register("kirin", KirinJewel::new);
    public static final DeferredHolder<Jewel, ViperJewel> VIPER = Jewels.register("viper", ViperJewel::new);
    public static final DeferredHolder<Jewel, TortoiseJewel> TORTOISE = Jewels.register("tortoise", TortoiseJewel::new);
    public static final DeferredHolder<Jewel, ArcticHareJewel> ARCTIC_HARE = Jewels.register("arctic_hare", ArcticHareJewel::new);
    public static final DeferredHolder<Jewel, MoleJewel> MOLE = Jewels.register("mole", MoleJewel::new);
    public static final DeferredHolder<Jewel, HawkJewel> HAWK = Jewels.register("hawk", HawkJewel::new);
    public static final DeferredHolder<Jewel, DemigodJewel> DEMIGOD = Jewels.register("demigod", DemigodJewel::new);
    public static final DeferredHolder<Jewel, StriderJewel> STRIDER = Jewels.register("strider", () -> new StriderJewel(ElementType.FIRE, 10, (TagKey<Fluid>)FluidTags.LAVA));
    public static final DeferredHolder<Jewel, StriderJewel> WATER_STRIDER = Jewels.register("water_strider", () -> new StriderJewel(ElementType.WATER, 10, (TagKey<Fluid>)FluidTags.WATER));
    public static final DeferredHolder<Jewel, PiglinJewel> PIGLIN = Jewels.register("piglin", PiglinJewel::new);

    private Jewels() {
    }

    public static Item getJewelItem(Jewel jewel) {
        return JEWEL_ITEM_MAP.get(jewel);
    }

    private static <T extends Jewel> DeferredHolder<Jewel, T> register(String name, Supplier<? extends T> builder) {
        return DEFERRED_REGISTER.register(name, builder);
    }

    public static void register(IEventBus modBus) {
        Jewels.registerAliases(DEFERRED_REGISTER);
        DEFERRED_REGISTER.register(modBus);
    }

    public static void registerAliases(DeferredRegister<?> register) {
        register.addAlias(ElementalCraftApi.createRL("arctic_hares"), ElementalCraftApi.createRL("arctic_hare"));
    }

    public static void setup() {
        JEWEL_ITEM_MAP.clear();
        BuiltInRegistries.ITEM.stream().mapMulti(ElementalCraftUtils.cast(JewelItem.class)).forEach(i -> JEWEL_ITEM_MAP.put(i.getJewel(), (Item)i));
    }
}

