/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.attribute.AttributeJewel;
import sirttas.elementalcraft.jewel.handler.IJewelHandler;

public class JewelHelper {
    private JewelHelper() {
    }

    @Nullable
    public static Jewel getJewel(@Nonnull ItemStack stack) {
        return (Jewel)stack.get(ECDataComponents.JEWEL);
    }

    public static void setJewel(@Nonnull ItemStack stack, @Nonnull Jewel jewel) {
        if (stack.isEmpty()) {
            return;
        }
        stack.set(ECDataComponents.JEWEL, (Object)jewel);
    }

    public static List<Jewel> getAllJewels(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return Collections.emptyList();
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ArrayList<Jewel> list = new ArrayList<Jewel>();
        for (ItemStack item : livingEntity.getAllSlots()) {
            Jewel jewel = JewelHelper.getJewel(item);
            if (jewel == null) continue;
            list.add(jewel);
        }
        return list;
    }

    public static List<Jewel> getActiveJewels(Entity entity) {
        IJewelHandler handler = (IJewelHandler)entity.getCapability(IJewelHandler.CAPABILITY);
        if (handler != null) {
            return handler.getActiveJewels();
        }
        return Collections.emptyList();
    }

    public static boolean hasJewel(Entity entity, Jewel jewel) {
        return JewelHelper.getActiveJewels(entity).contains(jewel);
    }

    public static Multimap<Holder<Attribute>, AttributeModifier> getJewelsAttribute(Entity entity) {
        ArrayListMultimap map = ArrayListMultimap.create();
        for (Jewel jewel : JewelHelper.getActiveJewels(entity)) {
            if (!jewel.isTicking() || !(jewel instanceof AttributeJewel)) continue;
            AttributeJewel attributeJewel = (AttributeJewel)jewel;
            map.putAll(attributeJewel.getAttributes());
        }
        return map;
    }
}

