/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.jewel.Jewels;

public class Jewel
implements IElementTypeProvider,
ItemLike {
    private final ElementType elementType;
    private final int consumption;
    private final boolean ticking;
    private String descriptionId;
    private ResourceLocation key;
    private Item item;

    protected Jewel(ElementType elementType, int consumption, boolean ticking) {
        this.elementType = elementType;
        this.consumption = consumption;
        this.ticking = ticking;
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }

    public int getConsumption() {
        return this.consumption;
    }

    public boolean isTicking() {
        return this.ticking;
    }

    public ResourceLocation getKey() {
        if (this.key == null) {
            this.key = Jewels.REGISTRY.getKey((Object)this);
        }
        return this.key;
    }

    public ResourceLocation getModelName() {
        ResourceLocation id = this.getKey();
        return ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("elementalcraft/jewels/" + id.getPath()));
    }

    @Nonnull
    public String getDescriptionId() {
        if (this.descriptionId == null) {
            ResourceLocation id = this.getKey();
            this.descriptionId = "elementalcraft.jewel." + id.getNamespace() + "." + id.getPath();
        }
        return this.descriptionId;
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getDescriptionId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActive(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().instabuild) return true;
        }
        if (elementStorage == null) return false;
        if (elementStorage.extractElement(this.consumption, this.elementType, true) != this.consumption) return false;
        return true;
    }

    public final void consume(@Nonnull Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().instabuild) {
                return;
            }
        }
        this.consume(entity, (IElementStorage)entity.getCapability(ElementalCraftCapabilities.ElementStorage.ENTITY, null));
    }

    public void consume(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        if (elementStorage != null) {
            elementStorage.extractElement(this.consumption, this.elementType, false);
        }
    }

    public void appendHoverText(List<Component> tooltip) {
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.consumes", (Object[])new Object[]{this.elementType.getDisplayName()}).withStyle(ChatFormatting.YELLOW));
    }

    @NotNull
    public Item asItem() {
        if (this.item == null) {
            this.item = Jewels.getJewelItem(this);
        }
        return this.item;
    }
}

