/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.spell.book;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.spell.book.SpellBookMenu;

public class SpellBookScreen
extends AbstractContainerScreen<SpellBookMenu>
implements MenuAccess<SpellBookMenu> {
    private static final ResourceLocation CHEST_GUI_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/generic_54.png");

    public SpellBookScreen(SpellBookMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.imageHeight = 114 + SpellBookMenu.ROW_COUNT * 18;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(@Nonnull GuiGraphics guiGraphics, int x, int y) {
        MutableComponent text = Component.literal((String)MessageFormat.format("{0}/{1}", ((SpellBookMenu)this.menu).getSpellCount(), ECConfig.SERVER.spellBookMaxSpell.get()));
        super.renderLabels(guiGraphics, x, y);
        guiGraphics.drawString(this.font, (Component)text, this.imageWidth - this.font.width(text.getVisualOrderText()) - this.titleLabelX, this.titleLabelY, 0x404040);
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(CHEST_GUI_TEXTURE, i, j, 0, 0, this.imageWidth, SpellBookMenu.ROW_COUNT * 18 + 17);
        guiGraphics.blit(CHEST_GUI_TEXTURE, i, j + SpellBookMenu.ROW_COUNT * 18 + 17, 0, 126, this.imageWidth, 96);
    }
}

