/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.spell.book;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.menu.AbstractECMenu;
import sirttas.elementalcraft.container.menu.ECMenus;
import sirttas.elementalcraft.container.menu.IMenuOpenListener;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.spell.book.SpellBookPayload;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;

public class SpellBookMenu
extends AbstractECMenu
implements IMenuOpenListener {
    static final int ROW_COUNT = (Spells.REGISTRY.size() + 9 - 1) / 9;
    static final int SLOT_COUNT = ROW_COUNT * 9;
    private ItemStack book;
    private final Container inventory;
    private final Player player;

    public SpellBookMenu(int id, Inventory player) {
        this(id, player, new ItemStack(ECItems.SPELL_BOOK));
    }

    private SpellBookMenu(int id, Inventory playerInventoryIn, ItemStack book) {
        super(ECMenus.SPELL_BOOK, id);
        this.book = book;
        this.inventory = new SimpleContainer(SLOT_COUNT);
        this.player = playerInventoryIn.player;
        this.addSlots(playerInventoryIn);
    }

    public static SpellBookMenu create(int id, Inventory playerInventoryIn, ItemStack book) {
        return new SpellBookMenu(id, playerInventoryIn, book);
    }

    private void addSlots(Inventory playerInventoryIn) {
        for (int i = 0; i < ROW_COUNT; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new ScrollSlot(this.inventory, j + i * 9, 8 + j * 18, 18 + i * 18));
            }
        }
        this.addPlayerSlots(playerInventoryIn, 103 + (ROW_COUNT - 4) * 18);
    }

    public boolean canDragTo(Slot slotIn) {
        return slotIn.index > SLOT_COUNT;
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            ItemStack old = stack.copy();
            Holder<Spell> spell = SpellHelper.getSpell(stack);
            if (stack.is((Item)ECItems.SCROLL.get()) && SpellHelper.isValid(spell)) {
                if (index < SLOT_COUNT) {
                    this.removeSpell(stack);
                    return ItemStack.EMPTY;
                }
                if (this.canAddSpell(stack, spell)) {
                    this.addSpell(stack, spell);
                    return ItemStack.EMPTY;
                }
                if (stack.isEmpty()) {
                    slot.set(ItemStack.EMPTY);
                } else {
                    slot.setChanged();
                }
                return old;
            }
        }
        return ItemStack.EMPTY;
    }

    public void clicked(int slotId, int dragType, @Nonnull ClickType clickType, @Nonnull Player player) {
        Slot slot;
        Slot slot2 = slot = slotId >= 0 ? (Slot)this.slots.get(slotId) : null;
        if (slot == null || !slot.getItem().is((Item)ECItems.SPELL_BOOK.get())) {
            if (slotId < 0 || slotId >= SLOT_COUNT || clickType == ClickType.THROW || clickType == ClickType.QUICK_MOVE || clickType == ClickType.PICKUP_ALL) {
                super.clicked(slotId, dragType, clickType, player);
            } else if (clickType == ClickType.CLONE && player.getAbilities().instabuild && this.getCarried().isEmpty()) {
                if (slot != null && slot.hasItem()) {
                    ItemStack scroll = slot.getItem().copy();
                    scroll.setCount(1);
                    this.setCarried(scroll);
                }
            } else if (clickType == ClickType.PICKUP) {
                if (this.getCarried().isEmpty()) {
                    if (slot != null && slot.hasItem()) {
                        ItemStack stack = slot.getItem();
                        ItemStack scroll = stack.copy();
                        stack.shrink(1);
                        scroll.setCount(1);
                        SpellHelper.removeSpell(this.book, SpellHelper.getSpell(stack));
                        this.setCarried(scroll);
                        this.refresh();
                    }
                } else {
                    ItemStack stack = this.getCarried();
                    Holder<Spell> spell = SpellHelper.getSpell(stack);
                    if (stack.is((Item)ECItems.SCROLL.get()) && SpellHelper.isValid(spell)) {
                        SpellHelper.addSpell(this.book, spell);
                        this.setCarried(ItemStack.EMPTY);
                        this.refresh();
                    }
                }
            }
        }
    }

    public int getSpellCount() {
        int spellCount = SpellHelper.getSpellList(this.book).count();
        return spellCount > 0 ? spellCount : IntStream.range(0, SLOT_COUNT).map(i -> {
            ItemStack stack = this.inventory.getItem(i);
            return stack.isEmpty() ? 0 : stack.getCount();
        }).sum();
    }

    public void setBook(ItemStack book) {
        this.book = book;
        this.refresh();
    }

    public boolean canAddSpell(ItemStack stack, Holder<Spell> spell) {
        return stack.is((Item)ECItems.SCROLL.get()) && SpellHelper.isValid(spell) && !SpellHelper.getSpellList(stack).isFull();
    }

    @Override
    public void onOpen(Player player) {
        this.refresh();
    }

    private void refresh() {
        Map<Holder<Spell>, Integer> spells = SpellHelper.getSpellList(this.book).getSpells();
        AtomicInteger i = new AtomicInteger(0);
        spells.forEach((s, c) -> {
            ItemStack scroll = new ItemStack(ECItems.SCROLL);
            SpellHelper.setSpell(scroll, (Holder<Spell>)s);
            scroll.setCount(c.intValue());
            this.inventory.setItem(i.getAndIncrement(), scroll);
        });
        for (int j = i.get(); j < SLOT_COUNT; ++j) {
            this.inventory.setItem(j, ItemStack.EMPTY);
        }
        this.slots.forEach(Slot::setChanged);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SpellBookPayload(this.book), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void removeSpell(ItemStack stack) {
        Holder<Spell> spell = SpellHelper.getSpell(stack);
        if (SpellHelper.isValid(spell)) {
            for (int i = 0; i < this.slots.size(); ++i) {
                Slot slot = (Slot)this.slots.get(i + SLOT_COUNT);
                if (slot.hasItem()) continue;
                ItemStack scroll = new ItemStack(ECItems.SCROLL);
                SpellHelper.setSpell(scroll, spell);
                slot.set(scroll);
                stack.shrink(1);
                SpellHelper.removeSpell(this.book, spell);
                slot.setChanged();
                this.refresh();
                return;
            }
        }
    }

    private void addSpell(ItemStack stack, Holder<Spell> spell) {
        for (int i = 0; i < SLOT_COUNT; ++i) {
            Slot slot = (Slot)this.slots.get(i);
            ItemStack stackInSlot = slot.getItem();
            if (!stackInSlot.isEmpty() && !spell.is(SpellHelper.getSpell(stackInSlot))) continue;
            stack.shrink(1);
            SpellHelper.addSpell(this.book, spell);
            this.refresh();
            return;
        }
    }

    private static class ScrollSlot
    extends Slot {
        public ScrollSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            return stack.is((Item)ECItems.SCROLL.get()) && this.getItem().isEmpty();
        }

        public int getMaxStackSize() {
            return (Integer)ECConfig.SERVER.spellBookMaxSpell.get();
        }
    }
}

