/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.spell.book;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.spell.book.SpellBookMenu;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;

public class SpellBookItem
extends Item {
    public static final String NAME = "spell_book";

    public SpellBookItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        return new InteractionResultHolder(this.open(level, player, stack), (Object)stack);
    }

    public InteractionResult open(Level level, Player player, ItemStack stack) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu((MenuProvider)new ContainerProvider(stack));
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        SpellHelper.getSpellList(stack).forEachSpell((spell, count) -> {
            if (count == 1) {
                tooltip.add((Component)Component.empty().append(((Spell)spell.value()).getDisplayName()).withStyle(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)Component.literal((String)(count + " ")).append(((Spell)spell.value()).getDisplayName()).withStyle(ChatFormatting.GRAY));
            }
        });
    }

    public int getBarWidth(@Nonnull ItemStack stack) {
        return Math.round((float)((Integer)ECConfig.SERVER.spellBookMaxSpell.get()).intValue() - (float)SpellHelper.getSpellList(stack).count() * 13.0f / (float)((Integer)ECConfig.SERVER.spellBookMaxSpell.get()).intValue());
    }

    private static class ContainerProvider
    implements MenuProvider {
        private final ItemStack stack;

        private ContainerProvider(ItemStack stack) {
            this.stack = stack;
        }

        public AbstractContainerMenu createMenu(int id, @Nonnull Inventory inventory, @Nonnull Player palyer) {
            return SpellBookMenu.create(id, inventory, this.stack);
        }

        @Nonnull
        public Component getDisplayName() {
            return this.stack.getHoverName();
        }
    }
}

