/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.spell;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import sirttas.elementalcraft.item.spell.AbstractSpellHolderItem;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;

public class ScrollItem
extends AbstractSpellHolderItem {
    public static final String NAME = "scroll";

    public ScrollItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected void consume(ItemStack stack) {
        stack.shrink(1);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        Holder<Spell> spell = SpellHelper.getSpell(stack);
        if (SpellHelper.isValid(spell)) {
            tooltip.add((Component)Component.empty().append(((Spell)spell.value()).getDisplayName()).withStyle(ChatFormatting.GRAY));
            this.addAttributeTooltip(tooltip, (Spell)spell.value());
        }
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        Holder<Spell> spell = SpellHelper.getSpell(stack);
        if (SpellHelper.isValid(spell)) {
            return Component.translatable((String)"tooltip.elementalcraft.scroll_of", (Object[])new Object[]{((Spell)spell.value()).getDisplayName()});
        }
        return super.getName(stack);
    }
}

