/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.spell;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.attributes.AttributesHelper;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.TooltipHelper;
import sirttas.elementalcraft.item.spell.ISpellHolder;
import sirttas.elementalcraft.spell.ItemAbilitySpell;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.tick.SpellTickHelper;

public abstract class AbstractSpellHolderItem
extends Item
implements ISpellHolder {
    protected AbstractSpellHolderItem(Item.Properties properties) {
        super(properties);
    }

    protected void addAttributeTooltip(List<Component> tooltip, Spell spell) {
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.consumes", (Object[])new Object[]{spell.getElementType().getDisplayName()}).withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.cooldown", (Object[])new Object[]{spell.getCooldown() / 20}).withStyle(ChatFormatting.YELLOW));
        spell.addInformation(tooltip);
        TooltipHelper.addAttributeMultiMapToTooltip(tooltip, spell.getOnUseAttributeModifiers(), (Component)Component.translatable((String)"tooltip.elementalcraft.on_spell_use").withStyle(ChatFormatting.GRAY));
    }

    public int getUseDuration(@Nonnull ItemStack stack, @NotNull LivingEntity entity) {
        return ((Spell)SpellHelper.getSpell(stack).value()).getUseDuration();
    }

    @Nonnull
    public UseAnim getUseAnimation(@Nonnull ItemStack stack) {
        return ((Spell)SpellHelper.getSpell(stack).value()).getUseAnimation();
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        return new InteractionResultHolder(this.tick(level, player, hand, stack, true), (Object)stack);
    }

    public void onUseTick(@Nonnull Level level, @Nonnull LivingEntity entity, @Nonnull ItemStack stack, int count) {
        block3: {
            block2: {
                if (!(entity instanceof Player)) break block2;
                Player player = (Player)entity;
                if (this.tick(entity.level(), player, entity.getUsedItemHand(), stack, false) == InteractionResult.CONSUME) break block3;
            }
            entity.releaseUsingItem();
        }
    }

    public void releaseUsing(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity entityLiving, int timeLeft) {
        this.finishUsingItem(stack, level, entityLiving);
    }

    @Nonnull
    public ItemStack finishUsingItem(@Nonnull ItemStack stack, Level level, @Nonnull LivingEntity entityLiving) {
        block2: {
            block3: {
                if (level.isClientSide) break block2;
                if (!(entityLiving instanceof Player)) break block3;
                Player player = (Player)entityLiving;
                if (player.getAbilities().instabuild) break block2;
            }
            SpellTickHelper.startCooldown((Entity)entityLiving, (Spell)SpellHelper.getSpell(stack).value());
        }
        return stack;
    }

    private InteractionResult tick(Level level, Player player, InteractionHand hand, ItemStack stack, boolean doChannel) {
        InteractionResult result;
        Spell spell = (Spell)SpellHelper.getSpell(stack).value();
        Multimap<Holder<Attribute>, AttributeModifier> attributes = spell.getOnUseAttributeModifiers();
        AttributeMap attributeMap = player.getAttributes();
        AttributesHelper.addAttributes(attributeMap, attributes);
        InteractionResult interactionResult = result = Boolean.TRUE.equals(ECConfig.SERVER.spellConsumeOnFail.get()) || spell.consume((Entity)player, true) ? this.castSpell(player, spell) : InteractionResult.FAIL;
        if (result.consumesAction()) {
            if (this.doConsume(player, hand, stack, spell)) {
                result = InteractionResult.SUCCESS;
            }
            if (result.shouldSwing() && !player.getAbilities().instabuild) {
                if (!level.isClientSide) {
                    SpellTickHelper.startCooldown((Entity)player, spell);
                }
                player.releaseUsingItem();
            } else if (doChannel && spell.isChannelable()) {
                player.startUsingItem(hand);
            }
        } else {
            player.releaseUsingItem();
        }
        AttributesHelper.removeAttributes(attributeMap, attributes);
        return result;
    }

    private InteractionResult castSpell(Player player, Spell spell) {
        if (SpellTickHelper.hasCooldown((Entity)player, spell)) {
            return InteractionResult.PASS;
        }
        InteractionResult result = InteractionResult.PASS;
        HitResult ray = EntityHelper.rayTrace((Entity)player);
        HitResult.Type rayType = ray.getType();
        if (rayType == HitResult.Type.ENTITY && ray instanceof EntityHitResult) {
            EntityHitResult entityRay = (EntityHitResult)ray;
            result = spell.castOnEntity((Entity)player, entityRay.getEntity());
        }
        if (rayType == HitResult.Type.BLOCK && !result.consumesAction() && ray instanceof BlockHitResult) {
            BlockHitResult blockRay = (BlockHitResult)ray;
            result = spell.castOnBlock((Entity)player, blockRay.getBlockPos(), blockRay);
        }
        if (!result.consumesAction()) {
            result = spell.castOnSelf((Entity)player);
        }
        return result;
    }

    private boolean doConsume(Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        if (!player.getAbilities().instabuild && !spell.consume((Entity)player, false)) {
            this.consume(stack);
            player.onEquippedItemBroken((Item)this, LivingEntity.getSlotForHand((InteractionHand)hand));
            return true;
        }
        return false;
    }

    protected abstract void consume(ItemStack var1);

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility itemAbility) {
        ItemAbilitySpell toolActionSpell;
        Holder<Spell> holder = SpellHelper.getSpell(stack);
        return holder instanceof ItemAbilitySpell && (toolActionSpell = (ItemAbilitySpell)holder).getItemAbilities().contains(itemAbility);
    }
}

