/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.source.receptacle;

import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.source.trait.holder.ISourceTraitHolder;
import sirttas.elementalcraft.block.source.SourceBlock;
import sirttas.elementalcraft.block.source.trait.holder.ItemSourceTraitHolder;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.element.storage.AbstractItemStackSingleElementStorage;

public class ReceptacleItem
extends BlockItem
implements IElementTypeProvider {
    public ReceptacleItem(SourceBlock source, Item.Properties properties) {
        super((Block)source, properties);
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return ((SourceBlock)this.getBlock()).getElementType();
    }

    @NotNull
    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    @NotNull
    public static ISourceTraitHolder getTraitHolder(ItemStack stack) {
        return (ISourceTraitHolder)stack.getOrDefault(ECDataComponents.SOURCE_TRAITS_HOLDER, (Object)ItemSourceTraitHolder.EMPTY);
    }

    public ISingleElementStorage getElementStorage(ItemStack stack) {
        return new ElementStorage(stack);
    }

    private class ElementStorage
    extends AbstractItemStackSingleElementStorage {
        private ElementStorage(ItemStack stack) {
            super(stack);
        }

        @Override
        public int getElementCapacity() {
            return ReceptacleItem.getTraitHolder(this.stack).getCapacity();
        }

        @Override
        @NotNull
        public ElementType getElementType() {
            return ReceptacleItem.this.getElementType();
        }
    }
}

