/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.source.receptacle;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.source.trait.holder.ItemSourceTraitHolder;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleItem;

public class ReceptacleHelper {
    private ReceptacleHelper() {
    }

    public static ElementType getElementType(ItemStack stack) {
        if (stack.is(ECItems.EMPTY_RECEPTACLE)) {
            return ElementType.NONE;
        }
        return ElementType.getElementType(stack);
    }

    public static ItemStack create(ElementType elementType) {
        return switch (elementType) {
            default -> throw new MatchException(null, null);
            case ElementType.FIRE -> new ItemStack((ItemLike)ECBlocks.FIRE_SOURCE.get());
            case ElementType.WATER -> new ItemStack((ItemLike)ECBlocks.WATER_SOURCE.get());
            case ElementType.EARTH -> new ItemStack((ItemLike)ECBlocks.EARTH_SOURCE.get());
            case ElementType.AIR -> new ItemStack((ItemLike)ECBlocks.AIR_SOURCE.get());
            case ElementType.NONE -> new ItemStack(ECItems.EMPTY_RECEPTACLE);
        };
    }

    public static ItemStack create(ElementType elementType, Map<Holder<SourceTrait>, ISourceTraitValue> traits) {
        ItemStack stack = ReceptacleHelper.create(elementType);
        stack.set(ECDataComponents.SOURCE_TRAITS_HOLDER, (Object)ItemSourceTraitHolder.from(traits));
        stack.set(ECDataComponents.ELEMENT_AMOUNT, (Object)ReceptacleItem.getTraitHolder(stack).getCapacity());
        return stack;
    }
}

