/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.source.receptacle;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;
import sirttas.elementalcraft.tag.ECTags;

public class EmptyReceptacleItem
extends Item {
    public static final String NAME = "empty_receptacle";

    public EmptyReceptacleItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState blockstate = level.getBlockState(pos);
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        if (blockstate.is(ECTags.Blocks.SOURCES)) {
            if (!level.isClientSide) {
                EmptyReceptacleItem.spawnReceptacle(level, pos, player);
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                if (player != null && !player.getAbilities().instabuild) {
                    player.getItemInHand(hand).shrink(1);
                    if (player.getItemInHand(hand).isEmpty()) {
                        player.setItemInHand(hand, ItemStack.EMPTY);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static void spawnReceptacle(Level level, BlockPos pos, @Nullable Player player) {
        SourceBlockEntity source = BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos, SourceBlockEntity.class).orElse(null);
        if (source == null) {
            return;
        }
        ItemStack receptacle = ReceptacleHelper.create(source.getElementType());
        receptacle.applyComponents(source.collectComponents());
        EmptyReceptacleItem.dropItem(level, pos, player, receptacle);
        if (source.isStabilized()) {
            source.setStabilized(false);
            EmptyReceptacleItem.dropItem(level, pos, player, new ItemStack(ECItems.SOURCE_STABILIZER));
        }
    }

    private static void dropItem(Level level, BlockPos pos, @Nullable Player player, ItemStack stack) {
        if (player != null) {
            EntityHelper.dropAtFeet(level, (Entity)player, stack);
        } else {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, stack));
        }
    }
}

