/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.source.analysis;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.container.menu.screen.IRefreshedScreen;
import sirttas.elementalcraft.item.source.analysis.SourceAnalysisGlassMenu;

public class SourceAnalysisGlassScreen
extends AbstractContainerScreen<SourceAnalysisGlassMenu>
implements MenuAccess<SourceAnalysisGlassMenu>,
IRefreshedScreen {
    private static final ResourceLocation SOURCE_ANALYSIS_GLASS_GUI_TEXTURE = ElementalCraftApi.createRL("textures/gui/container/source_analysis_glass.png");
    private TraitsList traitsList;

    public SourceAnalysisGlassScreen(SourceAnalysisGlassMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.imageHeight = 180;
        this.inventoryLabelY += 14;
    }

    protected void init() {
        super.init();
        this.traitsList = new TraitsList(this.minecraft);
        this.addRenderableWidget((GuiEventListener)this.traitsList);
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(SOURCE_ANALYSIS_GLASS_GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    public void refresh() {
        this.traitsList.refresh();
    }

    private class TraitsList
    extends ObjectSelectionList<Entry> {
        private static final int WIDTH = 158;
        private static final int HEIGHT = 62;

        public TraitsList(Minecraft minecraft) {
            super(minecraft, 158, 62, SourceAnalysisGlassScreen.this.topPos + SourceAnalysisGlassScreen.this.titleLabelY + 13, 11);
            this.setX(SourceAnalysisGlassScreen.this.leftPos + SourceAnalysisGlassScreen.this.titleLabelX + 2);
        }

        public int getRowWidth() {
            return 151;
        }

        protected int getScrollbarPosition() {
            return this.getRight() - 7;
        }

        protected int getRowTop(int index) {
            return super.getRowTop(index) - 4;
        }

        protected void renderDecorations(@Nonnull GuiGraphics guiGraphics, int x, int y) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SOURCE_ANALYSIS_GLASS_GUI_TEXTURE);
            guiGraphics.blit(SOURCE_ANALYSIS_GLASS_GUI_TEXTURE, this.getX(), this.getY() - 11, 0, SourceAnalysisGlassScreen.this.imageHeight, 158, 11);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            guiGraphics.blit(SOURCE_ANALYSIS_GLASS_GUI_TEXTURE, -this.getRight(), -this.getBottom() - 11, 0, SourceAnalysisGlassScreen.this.imageHeight, 158, 11);
            poseStack.popPose();
        }

        public void refresh() {
            this.clearEntries();
            ((SourceAnalysisGlassMenu)SourceAnalysisGlassScreen.this.menu).getTraits().values().forEach(value -> this.addEntry((AbstractSelectionList.Entry)new Entry((ISourceTraitValue)value)));
        }

        private class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final ISourceTraitValue value;

            private Entry(ISourceTraitValue value) {
                this.value = value;
            }

            @Nonnull
            public Component getNarration() {
                return this.value.getDescription();
            }

            public void render(@Nonnull GuiGraphics guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
                guiGraphics.drawString(SourceAnalysisGlassScreen.this.font, this.getNarration(), left, top, -1);
            }
        }
    }
}

