/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.source.analysis;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.item.source.analysis.SourceAnalysisGlassMenu;
import sirttas.elementalcraft.property.ECProperties;

public class SourceAnalysisGlassItem
extends Item {
    public static final String NAME = "source_analysis_glass";

    public SourceAnalysisGlassItem() {
        super(ECProperties.Items.ITEM_UNSTACKABLE);
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        return BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos, SourceBlockEntity.class).map(source -> this.open(level, player, source.getTraitHolder().getTraits())).orElse(InteractionResult.PASS);
    }

    public InteractionResult open(Level level, Player player, Map<Holder<SourceTrait>, ISourceTraitValue> traitMap) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu((MenuProvider)new Menu(traitMap));
        return InteractionResult.CONSUME;
    }

    private class Menu
    implements MenuProvider {
        private final Map<Holder<SourceTrait>, ISourceTraitValue> traits;

        private Menu(Map<Holder<SourceTrait>, ISourceTraitValue> traits) {
            this.traits = traits;
        }

        public AbstractContainerMenu createMenu(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new SourceAnalysisGlassMenu(id, inventory, this.traits);
        }

        @Nonnull
        public Component getDisplayName() {
            return SourceAnalysisGlassItem.this.getDescription();
        }
    }
}

