/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.source;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.property.ECProperties;

public class SourceStabilizerItem
extends Item {
    public static final String NAME = "source_stabilizer";

    public SourceStabilizerItem() {
        super(ECProperties.Items.ITEM_UNSTACKABLE);
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        return BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos, SourceBlockEntity.class).map(source -> {
            if (player != null && !source.isStabilized()) {
                source.setStabilized(true);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                    if (stack.isEmpty()) {
                        player.setItemInHand(context.getHand(), ItemStack.EMPTY);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }
}

