/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.rune;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.item.pipe.IPipeInteractingItem;

public class RuneItem
extends Item
implements IPipeInteractingItem {
    public static final String NAME = "rune";

    public RuneItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        return this.doUse(BlockEntityHelper.getRuneHandlerAt((LevelReader)context.getLevel(), context.getClickedPos()), context).result();
    }

    @Override
    @Nonnull
    public ItemInteractionResult useOnPipe(@Nonnull ElementPipeBlockEntity pipe, @Nonnull UseOnContext context) {
        return this.doUse(BlockEntityHelper.getCapability(ElementalCraftCapabilities.RuneHandler.BLOCK, pipe, context.getClickedFace()), context);
    }

    @Nonnull
    public ItemInteractionResult doUse(IRuneHandler handler, UseOnContext context) {
        if (handler == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        Holder<Rune> rune = RuneItem.getRune(stack);
        if (rune != null && ((Rune)rune.value()).canUpgrade((LevelReader)level, pos, context.getClickedFace(), handler)) {
            handler.addRune((Rune)rune.value());
            if (player != null && !player.getAbilities().instabuild) {
                stack.shrink(1);
                if (stack.isEmpty()) {
                    player.setItemInHand(context.getHand(), ItemStack.EMPTY);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static Holder<Rune> getRune(ItemStack stack) {
        return (Holder)stack.get(ECDataComponents.RUNE);
    }

    public ItemStack getRuneStack(Rune rune) {
        return this.getRuneStack(rune.getId());
    }

    public ItemStack getRuneStack(ResourceLocation rune) {
        return this.getRuneStack((Holder<Rune>)ElementalCraftApi.RUNE_MANAGER.getOrCreateHolder(rune));
    }

    public ItemStack getRuneStack(Holder<Rune> rune) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(ECDataComponents.RUNE, rune);
        return stack;
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        Holder<Rune> rune = RuneItem.getRune(stack);
        if (rune != null) {
            ((Rune)rune.value()).addInformation(tooltip, flag);
        }
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        Holder<Rune> rune = RuneItem.getRune(stack);
        if (rune != null) {
            return ((Rune)rune.value()).getDisplayName();
        }
        return super.getName(stack);
    }
}

