/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.pureore;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import sirttas.elementalcraft.pureore.PureOre;
import sirttas.elementalcraft.pureore.display.PureOreDisplayManager;

public class PureOreItem
extends Item {
    public static final String NAME = "pure_ore";

    public PureOreItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        Component name = PureOreDisplayManager.getInstance().getPureOreName(stack);
        if (name != null) {
            return name;
        }
        return super.getName(stack);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (flag.isAdvanced()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.pure_ore.id", (Object[])new Object[]{PureOre.getId(stack).toString()}).withStyle(ChatFormatting.GRAY));
            int[] colors = PureOreDisplayManager.getInstance().getColors(stack);
            if (colors != null && colors.length > 0) {
                tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.pure_ore.colors", (Object[])new Object[]{this.getColorText(colors[0]), this.getColorText(colors[1]), this.getColorText(colors[2])}).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    private String getColorText(int color) {
        return "#" + Integer.toHexString(color).substring(2).toUpperCase();
    }
}

