/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.pipe;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.item.pipe.IPipeInteractingItem;

public class PipeUpgradeItem
extends Item
implements IPipeInteractingItem {
    private final Supplier<PipeUpgradeType<?>> supplier;
    private PipeUpgradeType<?> pipeUpgradeType;

    public PipeUpgradeItem(Supplier<PipeUpgradeType<?>> supplier, Item.Properties properties) {
        super(properties);
        this.supplier = supplier;
    }

    public PipeUpgradeType<?> getPipeUpgradeType() {
        if (this.pipeUpgradeType == null) {
            this.pipeUpgradeType = this.supplier.get();
        }
        return this.pipeUpgradeType;
    }

    @Override
    @Nonnull
    public ItemInteractionResult useOnPipe(@Nonnull ElementPipeBlockEntity pipe, @Nonnull UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Direction face = context.getClickedFace();
        Player player = context.getPlayer();
        Level level = pipe.getLevel();
        if (level == null || pipe.getUpgrade(face) != null) {
            return ItemInteractionResult.FAIL;
        }
        Object upgrade = this.getPipeUpgradeType().create(pipe, face);
        CustomData customData = (CustomData)stack.getOrDefault(ECDataComponents.PIPE_UPGRADE_DATA, (Object)CustomData.EMPTY);
        if (!customData.isEmpty()) {
            ((PipeUpgrade)((Object)upgrade)).load(customData.copyTag(), (HolderLookup.Provider)level.registryAccess());
        }
        if (((PipeUpgrade)((Object)upgrade)).canPlace(pipe.getConnection(face))) {
            pipe.setUpgrade(face, (PipeUpgrade)((Object)upgrade));
            if (player != null && !player.getAbilities().instabuild) {
                stack.shrink(1);
                if (stack.isEmpty()) {
                    player.setItemInHand(context.getHand(), ItemStack.EMPTY);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    @Nonnull
    public String getDescriptionId() {
        return this.pipeUpgradeType.getDescriptionId();
    }
}

