/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.pipe;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;

public class CoverFrameItem
extends Item {
    public static final String NAME = "cover_frame";

    public CoverFrameItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof ElementPipeBlock && state.getValue(ElementPipeBlock.COVER) == ElementPipeBlock.CoverType.NONE) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(ElementPipeBlock.COVER, (Comparable)((Object)ElementPipeBlock.CoverType.FRAME)));
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
                if (stack.isEmpty()) {
                    player.setItemInHand(context.getHand(), ItemStack.EMPTY);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

