/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.holder;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ModConfigSpec;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.element.ElementAmounts;
import sirttas.elementalcraft.item.holder.AbstractElementHolderItem;

public class PureElementHolderItem
extends AbstractElementHolderItem {
    public static final String NAME = "pure_element_holder";

    public PureElementHolderItem(Item.Properties properties) {
        super(() -> ((ModConfigSpec.IntValue)ECConfig.SERVER.pureElementHolderCapacity).get(), () -> ((ModConfigSpec.IntValue)ECConfig.SERVER.pureElementHolderTransferAmount).get(), properties);
    }

    @Override
    public IElementStorage getElementStorage(ItemStack stack) {
        return new ElementStorage(stack);
    }

    @Override
    protected ElementType getElementType(IElementStorage target, BlockState blockstate) {
        if (target instanceof IElementTypeProvider) {
            IElementTypeProvider provider = (IElementTypeProvider)((Object)target);
            return provider.getElementType();
        }
        return ElementType.getElementType(blockstate);
    }

    private class ElementStorage
    implements IElementStorage {
        private final ItemStack stack;

        public ElementStorage(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public boolean usableInInventory() {
            return true;
        }

        @Override
        public int getElementAmount(ElementType type) {
            return ((ElementAmounts)this.stack.getOrDefault(ECDataComponents.ELEMENT_AMOUNTS, (Object)ElementAmounts.EMPTY)).get(type);
        }

        @Override
        public int getElementCapacity(ElementType type) {
            return PureElementHolderItem.this.getElementCapacity();
        }

        @Override
        public int insertElement(int count, ElementType type, boolean simulate) {
            int amount = this.getElementAmount(type);
            int newCount = Math.min(amount + count, this.getElementCapacity(type));
            int ret = count - newCount + amount;
            if (!simulate) {
                this.setAmount(type, newCount);
            }
            return ret;
        }

        @Override
        public int extractElement(int count, ElementType type, boolean simulate) {
            int amount = this.getElementAmount(type);
            int newCount = Math.max(amount - count, 0);
            int ret = amount - newCount;
            if (!simulate) {
                this.setAmount(type, newCount);
            }
            return ret;
        }

        @Override
        public void fill() {
            this.stack.set(ECDataComponents.ELEMENT_AMOUNTS, (Object)((ElementAmounts)this.stack.getOrDefault(ECDataComponents.ELEMENT_AMOUNTS, (Object)ElementAmounts.EMPTY)).with(ElementType.FIRE, this.getElementCapacity(ElementType.FIRE)).with(ElementType.WATER, this.getElementCapacity(ElementType.WATER)).with(ElementType.EARTH, this.getElementCapacity(ElementType.EARTH)).with(ElementType.AIR, this.getElementCapacity(ElementType.AIR)));
        }

        @Override
        public void fill(ElementType type) {
            this.setAmount(type, this.getElementCapacity(type));
        }

        private void setAmount(ElementType type, int newCount) {
            this.stack.set(ECDataComponents.ELEMENT_AMOUNTS, (Object)((ElementAmounts)this.stack.getOrDefault(ECDataComponents.ELEMENT_AMOUNTS, (Object)ElementAmounts.EMPTY)).with(type, newCount));
        }
    }
}

