/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.holder;

import javax.annotation.Nonnull;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.element.storage.AbstractItemStackSingleElementStorage;
import sirttas.elementalcraft.item.holder.AbstractElementHolderItem;

public class ElementHolderItem
extends AbstractElementHolderItem
implements IElementTypeProvider {
    public static final String NAME = "element_holder";
    public static final String NAME_FIRE = "element_holder_fire";
    public static final String NAME_WATER = "element_holder_water";
    public static final String NAME_EARTH = "element_holder_earth";
    public static final String NAME_AIR = "element_holder_air";
    private final ElementType elementType;

    public ElementHolderItem(ElementType elementType, Item.Properties properties) {
        super(() -> ((ModConfigSpec.IntValue)ECConfig.SERVER.elementHolderCapacity).get(), () -> ((ModConfigSpec.IntValue)ECConfig.SERVER.elementHolderTransferAmount).get(), properties);
        this.elementType = elementType;
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    protected ElementType getElementType(IElementStorage target, BlockState blockstate) {
        return this.elementType;
    }

    @Override
    public ISingleElementStorage getElementStorage(ItemStack stack) {
        return new ElementStorage(stack);
    }

    @Override
    protected boolean isValidSource(BlockState state) {
        return super.isValidSource(state) && ElementType.getElementType(state) == this.elementType;
    }

    public int getBarColor(@Nonnull ItemStack stack) {
        return this.elementType.getColor();
    }

    public int getBarWidth(@Nonnull ItemStack stack) {
        return Math.round((float)this.getElementStorage(stack).getElementAmount() * 13.0f / (float)this.getElementCapacity());
    }

    public boolean isBarVisible(@Nonnull ItemStack stack) {
        return true;
    }

    private class ElementStorage
    extends AbstractItemStackSingleElementStorage {
        private ElementStorage(ItemStack stack) {
            super(stack);
        }

        @Override
        public boolean usableInInventory() {
            return true;
        }

        @Override
        public int getElementCapacity() {
            return ElementHolderItem.this.getElementCapacity();
        }

        @Override
        @NotNull
        public ElementType getElementType() {
            return ElementHolderItem.this.elementType;
        }
    }
}

