/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.holder;

import java.util.Optional;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.tooltip.ElementGaugeTooltip;
import sirttas.elementalcraft.block.source.SourceElementStorage;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.tag.ECTags;

public abstract class AbstractElementHolderItem
extends Item {
    private final IntSupplier elementCapacity;
    private final IntSupplier transferAmount;

    protected AbstractElementHolderItem(IntSupplier elementCapacity, IntSupplier transferAmount, Item.Properties properties) {
        super(properties);
        this.elementCapacity = elementCapacity;
        this.transferAmount = transferAmount;
    }

    public abstract IElementStorage getElementStorage(ItemStack var1);

    public int getUseDuration(@Nonnull ItemStack stack, @NotNull LivingEntity entity) {
        return this.getElementCapacity() / this.getTransferAmount();
    }

    public int getElementCapacity() {
        return this.elementCapacity.getAsInt();
    }

    public int getTransferAmount() {
        return this.transferAmount.getAsInt();
    }

    @Nonnull
    public UseAnim getUseAnimation(@Nonnull ItemStack stack) {
        return UseAnim.BOW;
    }

    protected boolean isValidSource(BlockState state) {
        return state.is(ECTags.Blocks.SOURCES);
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack;
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        InteractionResult result = this.tick(level, (LivingEntity)player, pos, stack = context.getItemInHand());
        if (result.consumesAction()) {
            stack.set(ECDataComponents.TARGET_POS, (Object)pos);
            player.startUsingItem(context.getHand());
        }
        return result;
    }

    public void onUseTick(@Nonnull Level level, @Nonnull LivingEntity player, @Nonnull ItemStack stack, int count) {
        double reach;
        BlockPos pos = (BlockPos)stack.get(ECDataComponents.TARGET_POS);
        if (pos == null) {
            return;
        }
        AttributeInstance reachAttribute = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        double d = reach = reachAttribute != null ? reachAttribute.getValue() : 5.0;
        if (player.blockPosition().distSqr((Vec3i)pos) + 1.0 > reach * reach || !this.tick(player.level(), player, pos, stack).consumesAction()) {
            player.releaseUsingItem();
        }
    }

    public void releaseUsing(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity entityLiving, int timeLeft) {
        stack.remove(ECDataComponents.TARGET_POS);
    }

    protected abstract ElementType getElementType(IElementStorage var1, BlockState var2);

    private InteractionResult tick(Level level, LivingEntity entity, BlockPos pos, ItemStack stack) {
        int amount = this.transferAmount.getAsInt();
        BlockState blockstate = level.getBlockState(pos);
        IElementStorage storage = (IElementStorage)level.getCapability(ElementalCraftCapabilities.ElementStorage.BLOCK, pos, null);
        if (storage == null) {
            return InteractionResult.PASS;
        }
        IElementStorage holder = this.getElementStorage(stack);
        boolean isSource = this.isValidSource(blockstate);
        ElementType elementType = this.getElementType(storage, blockstate);
        if (elementType == ElementType.NONE) {
            return InteractionResult.PASS;
        }
        if (isSource || entity.isShiftKeyDown()) {
            if (isSource || storage.canPipeExtract(elementType, null)) {
                int value = storage.transferTo(holder, elementType, amount);
                if (value > 0) {
                    ParticleHelper.createElementFlowParticle(elementType, level, Vec3.atCenterOf((Vec3i)pos), entity.getRopeHoldPosition(0.0f), level.random);
                    if (isSource && storage.getElementAmount(elementType) <= 0) {
                        SourceElementStorage sourceStorage;
                        if (storage instanceof SourceElementStorage && (sourceStorage = (SourceElementStorage)storage).getSource().isStabilized()) {
                            EntityHelper.dropAtFeet(level, (Entity)entity, new ItemStack(ECItems.SOURCE_STABILIZER));
                        }
                        level.removeBlock(pos, false);
                    }
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.PASS;
            }
        } else if (storage.canPipeInsert(elementType, null)) {
            int value = holder.transferTo(storage, elementType, amount);
            if (value > 0) {
                ParticleHelper.createElementFlowParticle(elementType, level, entity.getRopeHoldPosition(0.0f), Vec3.atCenterOf((Vec3i)pos), level.random);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return false;
    }

    @Nonnull
    public Optional<TooltipComponent> getTooltipImage(@Nonnull ItemStack stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        IElementStorage storage = (IElementStorage)stack.getCapability(ElementalCraftCapabilities.ElementStorage.ITEM, null);
        if (storage == null) {
            return Optional.empty();
        }
        return Optional.of(new ElementGaugeTooltip(storage));
    }
}

